<?php

namespace App\Http\Resources\User;

use App\Http\Resources\Avatar\AvatarResource;
use App\Http\Resources\ImageResource;
use App\Http\Resources\Question\UserAnswerResource;
use App\Http\Resources\User\UserSocialLinkResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserProfileWithAllDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // Initialize an array to hold the indexed images (1 to 6)
        $indexedImages = [];

        // Loop through indices 1 to 6
        for ($i = 1; $i <= 6; $i++) {
            // Find the image with the current index
            $image = $this->images->firstWhere('index', $i);

            // If an image is found for this index, return the ImageResource, else return null
            $indexedImages[] = $image ? new ImageResource($image) : null;
        }
        return [
            'id' => $this->id,
            'full_name' => $this->full_name,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'dial_code' => $this->dial_code,
            'image_url' => $this->image_url,
            'status' => $this->status,
            'ring' => $this->ring,
            'gender' => $this->gender,
            'height' => $this->height,
            'education_level' => $this->education_level,
            'career_field' => $this->career_field,
            'type' => $this->type,
            'country_code' => $this->country_code,
            'age' => $this->age,
            'about' => $this->about,
            'date_of_birth' => $this->date_of_birth,
            'device_id' => $this->device_id,
            'device_token' => $this->device_token,
            'is_location_enable' => $this->is_location_enable,
            'live_location' => $this->live_location,
            'last_active' => $this->last_active,
            'pin_point' => $this->pin_point,
            'pintpont_longitude' => $this->pintpont_longitude,
            'pintpont_latitude' => $this->pintpont_latitude,
            'longitude' => $this->longitude,
            'latitude' => $this->latitude,
            'address' => $this->address,
            'is_complete' => $this->is_complete,
            'is_verified' => $this->is_verified, // Corrected the typo here
            'nfc_tag' => $this->nfc_tag,
            'created_at' => $this->created_at,
            'preferences' => formatPreferenceAnswers($this->id, env('SERVER')),
            'user_answers' => UserAnswerResource::collection($this->userAnswers),
            'images' => $indexedImages,  // Return the 6 indexed images
            'social_link' => UserSocialLinkResource::collection($this->socialLinks),
            'verification_images' => ImageResource::collection($this->verificationimages),
            'hide_locations' => $this->userLocation,
            'avatar' => new AvatarResource($this->avatar)

        ];
    }
}
