<?php

namespace App\Http\Resources\User;

use App\Http\Resources\Post\AdminPostResource;
use App\Http\Resources\Post\PostResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserWithPostResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'image' => $this->image,
            'image_url' => $this->image_url,
            'status' => $this->status,
            'device_id' => $this->device_id,
            'device_token' => $this->device_token,
            'created_at' => $this->created_at,
            'posts' => AdminPostResource::collection($this->newsfeeds)
        ];
    }
}
