<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Avatar extends Model
{
    use HasFactory;

    protected $fillable = ['type'];
    protected $with = ['image'];

    public const IMAGES_DIRECTORY = 'images/avatar';
    public function image()
    {
        return $this->morphOne(Image::class, 'imageable');
    }
}
