<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChatMessage extends Model
{
    use HasFactory, SoftDeletes;
    public const IMAGES_DIRECTORY = 'message/store';

    protected $with = ['image'];

    protected $fillable = [
        'chat_id',
        'user_id',
        'message',
        'read_at',
    ];

    public function image()
    {
        return $this->morphOne(Image::class, 'imageable');
    }
    // Relationship
    public function chat()
    {
        return $this->belongsTo(Chat::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
