<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Event extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'date', 'address'];

    public const IMAGES_DIRECTORY = 'images/event';
    public function image()
    {
        return $this->morphOne(Image::class, 'imageable');
    }
}
