<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;

class Feedback extends Model
{
    use HasFactory, Notifiable;

    protected $table = 'feedbacks';
    protected $fillable = ['first_name', 'last_name', 'email', 'subject', 'message', 'type'];
    public const TYPE_USER = 'user';
    public const TYPE_GUEST = 'guest';
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
