<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;
    protected $fillable = [
        'total_price',
        'total_quantity',
        'status',
        'is_paid',
        'user_id',
    ];
    protected $with = ['address', 'details'];
    public const PENDING = 'pending';
    public const ACCEPTED = 'accepted';
    public const REJECTED = 'rejected';
    public const DELIVERED = 'delivered';
    public const PROCESSED = 'processed';
    public const CANCELLED = 'cancelled';

    public function details()
    {
        return $this->hasMany(OrderDetail::class);
    }

    public function address()
    {
        return $this->hasMany(OrderAddress::class);
    }
    protected static function boot()
    {
        parent::boot();
        static::creating(function ($order) {
            $deliveryCharges = DeliveryCharges::where('is_default', 1)->first();
            if ($deliveryCharges) {
                $order->delivery_charges = $deliveryCharges->amount;
            }
        });
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
