<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    public const IMAGES_DIRECTORY = 'pages/img/';

    protected $guarded = ['id'];

    protected $appends = ['photo_url'];

    public function getPhotoUrlAttribute()
    {
        return $this->photo ? asset(self::IMAGES_DIRECTORY.$this->photo, false) : asset("images/no-image.jpg", false);
    }

}
