<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;
    protected $with = ['category', 'productSizes'];
    public const IMAGES_DIRECTORY = 'images/product';
    public const ACTIVE = 'active';
    public const INACTIVE = 'inactive';
    public function images()
    {
        return $this->morphMany(Image::class, 'imageable');
    }
    public function getImageAttribute($value)
    {
        return $value ? asset("images/product/{$value}") : null;
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function ratings()
    {
        return $this->hasMany(Rating::class);
    }

    public function productSizes()
    {
        return $this->belongsToMany(Size::class, 'product_sizes');
    }

    public function isInWishlist()
    {
        return $this->hasOne(Wishlist::class)->where('user_id', auth()->id());
    }

}

