<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Report extends Model
{
    use HasFactory;
    protected $fillable = ['reportable_type', 'reportable_id', 'reason', 'user_id'];
    public const PENDING = 'pending';
    public const RESOLVED = 'resolved';
    public function reportable()
    {
        return $this->morphTo();
    }

    public function getTypeAttribute()
    {
        return class_basename($this->reportable_type);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
