<?php

namespace App\Models\Traits;

use App\Models\Reaction;

trait Reactable {
    
    public function reactions()
    {
        return $this->morphMany(Reaction::class, 'reactable');
    }    

    public function likes()
    {
        return $this->morphMany(Reaction::class, 'reactable')->where('type', 'like');
    }

    public function dislikes()
    {
        return $this->morphMany(Reaction::class, 'reactable')->where('type', 'dislikes');
    }    
}