<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $guarded = ['id'];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    public const RING_WHITE = 'white';
    public const RING_GREEN = 'green';
    public const RING_TAN = 'tan';
    public const MALE = 'male';
    public const FEMALE = 'female';
    public const OTHER = 'other';

    // Define the accessor for 'image_url'
    public function getImageUrlAttribute()
    {
        return $this->image ? asset("/images/profile/img/{$this->image}") : null;
    }
    public function images()
    {
        return $this->morphMany(Image::class, 'imageable')->whereNull('use_type');
    }
    public function singleImage()
    {
        return $this->morphOne(Image::class, 'imageable')->whereNull('use_type');
    }

    public function verificationimages()
    {
        return $this->morphMany(Image::class, 'imageable')->where('use_type', 'verification');
    }

    public function getFullNameAttribute()
    {
        return $this->first_name . " " . $this->last_name;
    }

    public const IMAGES_DIRECTORY = 'images/profile/img/';

    public function feedbacks()
    {
        return $this->hasMany(Feedback::class);
    }

    public function socialLinks()
    {
        return $this->hasMany(UserSocialLink::class);
    }

    public function preferences()
    {

        return $this->hasMany(UserPreference::class);
    }

    public function userLocation()
    {

        return $this->hasOne(UserLocation::class);
    }

    public function receivedFriendRequests()
    {
        return $this->hasMany(FriendRequest::class, 'receiver_id');
    }

    public function sentFriendRequests()
    {
        return $this->hasMany(FriendRequest::class, 'sender_id');
    }

    public function userAnswers()
    {
        return $this->hasMany(UserAnswer::class);
    }

    public function friends()
    {
        return $this->belongsToMany(User::class, 'friends', 'user_id', 'friend_id');
    }

    // public function friend()
    // {
    //     $friend = Friend::where(function ($query) {
    //         $query->where('from', $this->id)
    //             ->orWhere('to', $this->id);
    //     })
    //         ->where('status', Friend::ACCEPTED)
    //         ->first();

    //     return $friend ?: new Friend();
    // }

    public function orders(): HasMany
    {
        return $this->hasMany(Order::class, 'user_id', 'id');
    }

    public function avatar()
    {
        return $this->belongsTo(Avatar::class, 'avatar_id');
    }
}
