<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserLocation extends Model
{
    use HasFactory;
    // Define the table name (optional if the table name is the plural form of the model name)
    protected $table = 'user_locations';

    // Define the fillable attributes (this is for mass assignment)
    protected $fillable = [
        'user_id',
        'latitude',
        'longitude',
        'radius',
    ];

    // Define the relationship with the User model (assuming one-to-one relationship)
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
