<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserPreference extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'question_id', 'answer'];



    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function questionOption()
    {
        return $this->belongsTo(QuestionOption::class, 'question_id');
    }
    public function questionOptions()
    {

        // Decode the answer JSON and convert it into an array
        $answerIds = json_decode($this->answer, true) ?? [];

        // Return the related QuestionOption records
        return $this->belongsToMany(QuestionOption::class, 'question_options', 'id', 'id')
            ->whereIn('id', $answerIds);
    }

    
    public function question()
    {
        return $this->belongsTo(Question::class);
    }
}
