<?php

namespace App\Notifications;

use Illuminate\Notifications\Notification;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification as FirebaseNotification;
use Kreait\Firebase\Contract\Messaging as MessagingContract;

class PushNotification extends Notification
{
    private $title;
    private $body;

    public function __construct($title, $body)
    {
        $this->title = $title;
        $this->body = $body;
    }

    public function via($notifiable)
    {
        return ['firebase'];
    }

    public function toFirebase($notifiable)
    {
        $messaging = app(MessagingContract::class);

        $message = CloudMessage::new()
            ->withNotification(FirebaseNotification::create($this->title, $this->body))
            ->withData([
                'key' => 'value' // Custom data payload (optional)
            ]);

        return $messaging->send($message);
    }
}
