<?php

namespace App\Services;

use App\Models\Avatar;
use App\Models\StoreCategory;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Http\Resources\Json\JsonResource;
use Mockery\Exception;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class AvatarService extends BaseService
{
    public function index()
    {
        $avatars = Avatar::with('image')
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $avatars;
    }

    public function allAvatars()
    {
        $avatars = Avatar::with('image')
            ->orderBy('id', 'desc')
            ->get();
        return $avatars;
    }

    public function show($id)
    {
        $Avatar = Avatar::where('id', $id)->with('image')->first();
        return $Avatar;
    }

    public function store($request)
    {
        $Avatar = Avatar::create([
            'type' => $request->type,
        ]);
        if ($request->hasFile('image')) {
            storeImage($request, 'image', Avatar::IMAGES_DIRECTORY, $Avatar);
        }
        return $Avatar;
    }

    public function update($request, $Avatar)
    {
        $Avatar->type = $request->type;
        $Avatar->save();
        if ($request->hasFile('image')) {
            storeImage($request, 'image', Avatar::IMAGES_DIRECTORY, $Avatar);
        }
        return $Avatar;
    }


    public function delete($Avatar)
    {
        deleteImage($Avatar->image);
        $Avatar->delete();
        return "Avatar Deleted";
    }
}
