<?php

namespace App\Services;

use App\Models\Banner;
use App\Models\StoreCategory;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Http\Resources\Json\JsonResource;
use Mockery\Exception;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class BannerService extends BaseService
{
    public function index()
    {
        $storeCategories = Banner::with('image')
            ->when(request()->filled('search'), function ($q) {
                $q->where(function ($q) {
                    $q->where('title', 'like', '%' . request("search") . '%');
                });
            })
            ->when(request()->filled('fromDate'), function ($q) {
                $q->whereDate('created_at', '>=', request('fromDate'))
                    ->whereDate('created_at', '<=', request('toDate'));
            })
            ->when(request()->filled('expiryFromDate'), function ($q) {
                $q->whereDate('expiry_date', '>=', request('expiryFromDate'))
                    ->whereDate('expiry_date', '<=', request('expiryToDate'));
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $storeCategories;
    }

    public function show($id)
    {
        $banner = Banner::where('id', $id)->with('image')->first();
        return $banner;
    }

    public function store($request)
    {
        $banner = Banner::create([
            'title' => $request->title,
            'expiry_date' => $request->expiry_date,
        ]);
        if ($request->hasFile('image')) {
            storeImage($request, 'image', Banner::IMAGES_DIRECTORY, $banner);
        }
        return $banner;
    }

    public function update($request, $banner)
    {
        $banner->title = $request->title;
        $banner->expiry_date = $request->expiry_date;
        $banner->save();
        if ($request->hasFile('image')) {
            storeImage($request, 'image', Banner::IMAGES_DIRECTORY, $banner);
        }
        return $banner;
    }


    public function delete($banner)
    {
        deleteImage($banner->image);
        $banner->delete();
        return "Banner Deleted";
    }
}
