<?php

namespace App\Services;

use App\Models\Cart;
use App\Models\Product;
use App\Models\StoreCategory;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Http\Resources\Json\JsonResource;
use Mockery\Exception;
use Symfony\Component\HttpFoundation\Response;
use App\Services\ProductService;
/**
 * Class JsonResponseService
 * @package App\Services
 */
class CartService extends BaseService
{
    public function index()
    {
        $user_id = request('user_id');
        $cart = Cart::where('user_id', $user_id)->orderBy('id', 'desc')->get();
        return $cart;
    }

    public function show($id)
    {
        $user = User::where('id', $id)->first();
        return $user;
    }

    public function update($quantity, $cart)
    {

        $cart->quantity = $quantity;
        $cart->save();
        return $cart;
    }
    public function updateByProductId($request)
    {
        $cart = $this->checkCartItem($request->product_id);
        // dd($cart);
        if (!$cart) {
            $productService = new ProductService();
            $product = $productService->show($request->product_id);
            $cart = $this->store($product, $request->quantity, $request->user_id);
        }
        $cart->quantity = $request->quantity;
        $cart->save();
        return $cart;
    }

    public function checkCartItem($product_id, $user_id)
    {
        return Cart::where('user_id', $user_id)->where('product_id', $product_id)->first();
    }

    public function clearAllItems($user_id)
    {
        return Cart::where('user_id', $user_id)->delete();
    }

    public function checkItemQuantity($product_id, $quantity)
    {
        $checkLimit = Product::where('id', $product_id)->where('quantity', '>=', $quantity)->first();
        return $checkLimit;
    }

    public function delete($cart)
    {
        return $cart->delete();

    }

    public function store($product, $quantity, $size_id, $user_id)
    {
        // $this->clearAllItems($user_id);
        $cart = new Cart();
        $cart->quantity = $quantity;
        $cart->price = $product->price - $product->discounted_price;
        $cart->user_id = $user_id;
        $cart->product_id = $product->id;
        $cart->size_id = $size_id;
        $cart->save();
        return $cart;
    }


    public function accountStatus($userId)
    {
        $user = User::find($userId);
        $user->status = ($user->status == 1) ? 0 : 1;
        $user->save();
        return $user;
    }
}
