<?php

namespace App\Services;

use App\Models\Commission;
use App\Models\DeliveryCharges;
use App\Models\StoreCategory;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Http\Resources\Json\JsonResource;
use Mockery\Exception;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class DeliveryChargeService extends BaseService
{
    public function index()
    {
        $deliveryCharges = DeliveryCharges::when(request()->filled('search'), function ($q) {
            $q->where(function ($q) {
                $q->where('amount', 'like', '%' . request("search") . '%');
            });
        })
            ->when(request()->filled('fromDate'), function ($q) {
                $q->whereDate('created_at', '>=', request('fromDate'))->whereDate('created_at', '<=', request('toDate'));
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $deliveryCharges;
    }

    public function store($request)
    {
        DeliveryCharges::where('is_default', 1)->update(['is_default' => 0]);
        $deliveryCharge = DeliveryCharges::create([
            'amount' => $request->delivery_charges,
        ]);
        return $deliveryCharge;
    }

    public function currentDeliveryCharges()
    {
        $deliveryCharge = DeliveryCharges::where('is_default', 1)->first();
        return $deliveryCharge;
    }
}
