<?php

namespace App\Services;

use App\Models\Event;
use App\Models\StoreCategory;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Http\Resources\Json\JsonResource;
use Mockery\Exception;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class EventService extends BaseService
{
    public function index()
    {
        $event = Event::with('image')
            ->when(request()->filled('search'), function ($q) {
                $q->where(function ($q) {
                    $q->where('name', 'like', '%' . request("search") . '%');
                });
            })
            ->when(request()->filled('fromDate'), function ($q) {
                $q->whereDate('created_at', '>=', request('fromDate'))
                    ->whereDate('created_at', '<=', request('toDate'));
            })
            ->when(request()->filled('expiryFromDate'), function ($q) {
                $q->whereDate('expiry_date', '>=', request('expiryFromDate'))
                    ->whereDate('expiry_date', '<=', request('expiryToDate'));
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $event;
    }

    public function show($id)
    {
        $event = Event::where('id', $id)->with('image')->first();
        return $event;
    }

    public function store($request)
    {
        $event = Event::create([
            'name' => $request->name,
            'date' => $request->date,
            'address' => $request->address,
        ]);
        if ($request->hasFile('image')) {
            storeImage($request, 'image', Event::IMAGES_DIRECTORY, $event);
        }
        return $event;
    }

    public function update($request, $event)
    {

        $event->name = $request->name;
        $event->date = $request->date;
        $event->address = $request->address;
        $event->save();
        if ($request->hasFile('image')) {
            storeImage($request, 'image', Event::IMAGES_DIRECTORY, $event);
        }
        return $event;
    }


    public function delete($event)
    {
        deleteImage($event->image);
        $event->delete();
        return "Event Deleted";
    }
}
