<?php

namespace App\Services;

use App\Models\Cart;
use App\Models\DeliveryCharges;
use App\Models\Order;
use App\Models\OrderAddress;
use App\Models\OrderDetail;
use App\Models\PaymentLog;
use App\Services\Common\BaseService;
use Illuminate\Support\Facades\DB;


/**
 * Class JsonResponseService
 * @package App\Services
 */
class PaymentLogService extends BaseService
{

    public function index()
    {

        // $paymentLogs = PaymentLog::with(['user'])
        //     ->when(request()->filled('search'), function ($q) {
        //         $search = request('search');

        //         $q->where(function ($q) use ($search) {
        //             $q->where('id', 'like', '%' . $search . '%')
        //                 ->orWhereHas('user', function ($query) use ($search) {
        //                     $query->where('first_name', 'like', '%' . $search . '%')
        //                         ->orWhere('last_name', 'like', '%' . $search . '%')
        //                         ->orWhere('email', 'like', '%' . $search . '%')
        //                         ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . $search . '%');
        //                 });
        //         });
        //     })
        //     ->when(request()->filled('fromDate'), function ($q) {
        //         $q->whereDate('created_at', '>=', request('fromDate'))
        //             ->whereDate('created_at', '<=', request('toDate'));
        //     })
        //     ->orderBy('id', 'desc')
        //     ->paginate($this->pagination);
        // return $paymentLogs;
        $paymentLogs = PaymentLog::with(['user', 'paymentable.address']) // Eager load the order and address relationships
            ->when(request()->filled('search'), function ($q) {
                $search = request('search');

                $q->where(function ($q) use ($search) {
                    $q->where('id', 'like', '%' . $search . '%')
                        ->orWhereHas('user', function ($query) use ($search) {
                            $query->where('first_name', 'like', '%' . $search . '%')
                                ->orWhere('last_name', 'like', '%' . $search . '%')
                                ->orWhere('email', 'like', '%' . $search . '%')
                                ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . $search . '%');
                        })
                        ->orWhereHas('paymentable.address', function ($query) use ($search) {
                            $query->where('type', 'contact')  // Filter for type 'contact'
                                ->where(function ($query) use ($search) {
                                    $query->where('first_name', 'like', '%' . $search . '%')
                                        ->orWhere('last_name', 'like', '%' . $search . '%')
                                        ->orWhere('email', 'like', '%' . $search . '%')
                                        ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . $search . '%');
                                });
                        });
                });
            })
            ->when(request()->filled('fromDate'), function ($q) {
                $q->whereDate('created_at', '>=', request('fromDate'))
                    ->whereDate('created_at', '<=', request('toDate'));
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);

        // Filter address to only include type = 'contact'
        // $paymentLogs->getCollection()->transform(function ($paymentLog) {
        //     // Filter the addresses array to return only the one with type = 'contact'
        //     $paymentLog->paymentable->address = collect($paymentLog->paymentable->address)
        //         ->where('type', 'contact')
        //         ->values();  // Re-index the array

        //     return $paymentLog;
        // });

        return $paymentLogs;
    }
}
