<?php

namespace App\Services;

use App\Models\Friend;
use App\Models\Post;
use App\Models\StoreCategory;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Support\Facades\DB;


/**
 * Class JsonResponseService
 * @package App\Services
 */
class PostService extends BaseService
{
    public function index()
    {
        $query = Post::with('files')->orderBy('id', 'desc');
        $posts = $query->paginate($this->pagination);
        return $posts;
    }

    public function userWithPosts($user_id)
    {
        return User::with([
            'newsfeeds' => function ($query) {
                $query->orderBy('created_at', 'desc');
            }
        ])->where('id', $user_id)->first();
    }

    public function delete($post_id)
    {
        return Post::where('id', $post_id)->delete();
    }

    public function show($id)
    {
        $user = User::where('id', $id)->first();
        return $user;
    }

    public function store($request)
    {
        DB::beginTransaction();
        $post = new Post();
        $post->content = $request->content;
        $post->privacy = $request->privacy;
        $post->user_id = auth()->user()->id;
        $post->save();
        if ($request->hasFile('files')) {
            storeArrayOfImage($request, "files", Post::IMAGES_DIRECTORY, $post, "files");
        }
        DB::commit();
        return $post;
    }

    public function newsfeed($request)
    {
        $userId = auth()->id();
        $searchQuery = $request->input('search');
        $posts = Post::where(function ($query) use ($userId, $searchQuery) {
            // Own posts
            $query->where('user_id', $userId)
                // Posts from friends
                ->orWhereIn('user_id', function ($subQuery) use ($userId) {
                    $subQuery->select('to')
                        ->from('friends')
                        ->where('from', $userId)
                        ->where('status', Friend::ACCEPTED);
                })
                // Posts from friends of friends
                ->orWhereIn('user_id', function ($subQuery) use ($userId) {
                    $subQuery->select('to')
                        ->from('friends')
                        ->whereIn('from', function ($subSubQuery) use ($userId) {
                            $subSubQuery->select('to')
                                ->from('friends')
                                ->where('from', $userId)
                                ->where('status', Friend::ACCEPTED);
                        })
                        ->where('status', Friend::ACCEPTED);
                })
                // Public posts
                ->orWhere('privacy', 'public');
            if ($searchQuery) {
                $query->where('content', 'like', '%' . $searchQuery . '%');
            }
        })->paginate($this->pagination);
        return $posts;
    }

    public function update($request, $post)
    {
        $post->content = $request->content;
        $post->privacy = $request->privacy;
        $post->save();
        if ($request->hasFile('files')) {
            storeArrayOfImage($request, "files", Post::IMAGES_DIRECTORY, $post, "files");
        }
        return $post;
    }

    public function deleteProductImage($image)
    {
        return deleteImage($image);
    }


    public function accountStatus($userId)
    {
        $user = User::find($userId);
        $user->status = ($user->status == 1) ? 0 : 1;
        $user->save();
        return $user;
    }
}
