<?php

namespace App\Services;

use App\Models\Friend;
use App\Models\Post;
use App\Models\Question;
use App\Models\QuestionOption;
use App\Models\StoreCategory;
use App\Models\User;
use App\Models\UserAnswer;
use App\Models\UserLocation;
use App\Models\UserPreference;
use App\Services\Common\BaseService;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Phpml\Clustering\KMeans;
use App\Exceptions\BadRequestException;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class PreferenceService extends BaseService
{
    public function index()
    {
        $query = Question::orderBy('id', 'desc');
        $posts = $query->paginate($this->pagination);
        return $posts;
    }


    public function show($id)
    {
        $question = Question::where('id', $id)->first();
        return $question;
    }

    public function store($request)
    {
        $userId = auth()->id(); // Get the currently authenticated user ID
        if ($request->preferences) {

            foreach ($request->preferences as $preference) {
                UserPreference::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $preference['question_id'],
                    ],
                    [
                        'answer' => json_encode($preference['answer_ids']), // Store the answer IDs as JSON
                    ]
                );
            }
        }
        UserAnswer::where('user_id', $userId)->delete();
        if ($request->personal_preferences_and_lifestyle) {
            foreach ($request->personal_preferences_and_lifestyle as $personal_preferences_and_lifestyle_single) {
                // $question = Question::where('id', $personal_preferences_and_lifestyle_single['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $personal_preferences_and_lifestyle_single['question_id'],
                    ],
                    [
                        'answer' => $personal_preferences_and_lifestyle_single['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->food_and_cuisine) {
            foreach ($request->food_and_cuisine as $food_and_cuisin_single) {
                // $question = Question::where('id', $food_and_cuisin_single['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $food_and_cuisin_single['question_id'],
                    ],
                    [
                        'answer' => $food_and_cuisin_single['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->travel_and_adventure) {
            foreach ($request->travel_and_adventure as $travel_and_adventure_single) {
                // $question = Question::where('id', $travel_and_adventure_single['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $travel_and_adventure_single['question_id'],
                    ],
                    [
                        'answer' => $travel_and_adventure_single['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->trending) {
            foreach ($request->trending as $trendingSingle) {
                // $question = Question::where('id', $trendingSingle['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $trendingSingle['question_id'],
                    ],
                    [
                        'answer' => $trendingSingle['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->for_the_girls) {
            foreach ($request->for_the_girls as $for_the_girl) {
                // $question = Question::where('id', $for_the_girl['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $for_the_girl['question_id'],
                    ],
                    [
                        'answer' => $for_the_girl['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->for_the_guys) {
            foreach ($request->for_the_guys as $for_the_guy) {
                // $question = Question::where('id', $for_the_guy['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $for_the_guy['question_id'],
                    ],
                    [
                        'answer' => $for_the_guy['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->dreams_and_aspirations) {
            foreach ($request->dreams_and_aspirations as $dreams_and_aspiration) {
                // $question = Question::where('id', $dreams_and_aspiration['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $dreams_and_aspiration['question_id'],
                    ],
                    [
                        'answer' => $dreams_and_aspiration['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->entertainment_and_media) {
            foreach ($request->entertainment_and_media as $entertainment_and_mediaSingle) {
                // $question = Question::where('id', $entertainment_and_mediaSingle['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $entertainment_and_mediaSingle['question_id'],
                    ],
                    [
                        'answer' => $entertainment_and_mediaSingle['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->social_and_relationships) {
            foreach ($request->social_and_relationships as $social_and_relationship) {
                // $question = Question::where('id', $social_and_relationship['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $social_and_relationship['question_id'],
                    ],
                    [
                        'answer' => $social_and_relationship['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->unique_and_unusual) {
            foreach ($request->unique_and_unusual as $unique_and_unusualSingle) {
                // $question = Question::where('id', $unique_and_unusualSingle['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $unique_and_unusualSingle['question_id'],
                    ],
                    [
                        'answer' => $unique_and_unusualSingle['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->imagination_and_fantasy) {
            foreach ($request->imagination_and_fantasy as $imagination_and_fantasySingle) {
                // $question = Question::where('id', $imagination_and_fantasySingle['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $imagination_and_fantasySingle['question_id'],
                    ],
                    [
                        'answer' => $imagination_and_fantasySingle['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->skills_and_learning) {
            foreach ($request->skills_and_learning as $skills_and_learningSingle) {
                // $question = Question::where('id', $skills_and_learningSingle['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $skills_and_learningSingle['question_id'],
                    ],
                    [
                        'answer' => $skills_and_learningSingle['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->personal_reflections) {
            foreach ($request->personal_reflections as $personal_reflection) {
                // $question = Question::where('id', $personal_reflection['question_id'])->with('category')->first();
                // $questionIds = Question::where('question_category_id', $question->question_category_id)->pluck('id')->toArray();
                // UserAnswer::where('user_id', $userId)->whereIn('question_id', $questionIds)->delete();
                UserAnswer::updateOrCreate(
                    [
                        'user_id' => $userId,
                        'question_id' => $personal_reflection['question_id'],
                    ],
                    [
                        'answer' => $personal_reflection['answer'], // Store the answer IDs as JSON
                    ]
                );
            }
        }
        if ($request->ring) {
            auth()->user()->ring = $request->ring;

        }
        if ($request->ring) {
            auth()->user()->about = $request->about;
        }
        auth()->user()->save();
        return auth()->user();
    }
    public function getTopMatchedProfiles()
    {
        $topProfiles = User::select('users.*', DB::raw('COUNT(friends.id) as friend_count'))
            ->leftJoin('friends', function ($join) {
                $join->on('users.id', '=', 'friends.user_id')
                    ->orOn('users.id', '=', 'friends.friend_id');
            })
            ->where('users.type', '!=', 'admin') // Exclude users with type 'admin'
            ->where('users.id', '!=', request()->get('user_id'))// Exclude the logged-in user
            ->groupBy('users.id')
            ->orderByDesc('friend_count')
            ->take(4)
            ->get();
        return $topProfiles;
    }
    // public function getTopMatchedProfiles()
    // {
    //     $loggedInUser = auth()->user();

    //     // Check if the logged-in user has preferences
    //     if ($loggedInUser->preferences->isEmpty()) {
    //         return response()->json(['message' => 'Not enough users currently'], 400);
    //     }

    //     // Step 1: Load all users and their preferences in one go
    //     $allUsers = User::with('preferences')->get();

    //     // Step 2: Prepare to collect matched users
    //     $matchingUsers = [];

    //     // Step 3: Get the logged-in user's preferences
    //     $loggedInUserPreferences = $loggedInUser->preferences->keyBy('question_id');

    //     foreach ($allUsers as $user) {
    //         if ($user->id === $loggedInUser->id) {
    //             continue; // Skip the logged-in user
    //         }

    //         // Get the current user's preferences
    //         $userPreferences = $user->preferences->keyBy('question_id');

    //         // Step 4: Calculate matches
    //         $totalQuestions = count($loggedInUserPreferences);
    //         $matchingCount = 0;

    //         foreach ($loggedInUserPreferences as $questionId => $loggedInPreference) {
    //             if (isset($userPreferences[$questionId])) {
    //                 // Decode the answers from JSON string to array
    //                 $loggedInAnswers = json_decode($loggedInPreference->answer, true);
    //                 $userAnswers = json_decode($userPreferences[$questionId]->answer, true);

    //                 // Check for matches
    //                 $matches = count(array_intersect($loggedInAnswers, $userAnswers));
    //                 if ($matches > 0) {
    //                     $matchingCount++;
    //                 }
    //             }
    //         }

    //         // Step 5: Check if the matching count is at least 80%
    //         $matchPercentage = $matchingCount / $totalQuestions * 100;
    //         if ($totalQuestions > 0 && $matchPercentage >= 80) {
    //             $user->match_percentage = $matchPercentage;
    //             $matchingUsers[] = $user;
    //         }
    //     }

    //     // Step 6: Sort by match percentage, limit to 6 users, and return as JSON
    //     $limitedMatchingUsers = collect($matchingUsers)->sortByDesc('match_percentage')->take(6);

    //     return $limitedMatchingUsers->values()->all();
    // }


    public function getAllMatchedProfiles()
    {
        $loggedInUser = auth()->user();

        // Check if the logged-in user has preferences
        // if ($loggedInUser->preferences->isEmpty()) {
        //     return response()->json(['message' => 'Not enough users currently.'], 400);
        // }

        // Step 1: Load all users and their preferences in one go
        $allUsers = User::with('preferences')->get();

        // Step 2: Prepare to collect matched users
        $matchingUsers = [];

        // Step 3: Get the logged-in user's preferences
        $loggedInUserPreferences = $loggedInUser->preferences->keyBy('question_id');

        foreach ($allUsers as $user) {
            if ($user->id === $loggedInUser->id) {
                continue; // Skip the logged-in user
            }

            // Get the current user's preferences
            $userPreferences = $user->preferences->keyBy('question_id');

            // Step 4: Calculate matches
            $totalQuestions = count($loggedInUserPreferences);
            $matchingCount = 0;

            foreach ($loggedInUserPreferences as $questionId => $loggedInPreference) {
                if (isset($userPreferences[$questionId])) {
                    // Decode the answers from JSON string to array


                    $loggedInAnswers = json_decode($loggedInPreference->answer, true);
                    $userAnswers = json_decode($userPreferences[$questionId]->answer, true);
                    // Check for matches
                    $matches = count(array_intersect($loggedInAnswers, $userAnswers));
                    if ($matches > 0) {
                        $matchingCount++;
                    }
                }
            }

            // Step 5: Check if the matching count is at least 50%
            if ($totalQuestions > 0 && $matchingCount / $totalQuestions >= 0.5) {
                $user->count = $matchingCount / $totalQuestions * 100; // Add user to matching users
                $matchingUsers[] = $user; // Add user to matching users
            }
        }


        return $matchingUsers; // Return JSON response for API
    }

    // public function getMatchedProfiles()
    // {
    //     $loggedInUser = auth()->user();

    //     // Check if the logged-in user has preferences
    //     if ($loggedInUser->preferences->isEmpty()) {
    //         throw new BadRequestException('Not enough users currently.');
    //         // return response()->json(['message' => ''], 400);
    //     }

    //     // Step 1: Load all users and their preferences in one go
    //     $allUsers = User::with('preferences')->get();

    //     // Step 2: Prepare to collect matched users
    //     $matchingUsers = [];

    //     // Step 3: Get the logged-in user's preferences
    //     $loggedInUserPreferences = $loggedInUser->preferences->keyBy('question_id');

    //     // Step 4: Get the user's friends and sent/received friend requests
    //     $friendsIds = DB::table('friends')
    //         ->where('user_id', $loggedInUser->id)
    //         ->pluck('friend_id')
    //         ->toArray();

    //     $friendRequestsSentIds = DB::table('friend_requests')
    //         ->where('sender_id', $loggedInUser->id)
    //         ->pluck('receiver_id')
    //         ->toArray();

    //     $friendRequestsReceivedIds = DB::table('friend_requests')
    //         ->where('receiver_id', $loggedInUser->id)
    //         ->pluck('sender_id')
    //         ->toArray();

    //     // Combine all IDs to exclude from matches
    //     $excludedIds = array_merge($friendsIds, $friendRequestsSentIds, $friendRequestsReceivedIds);

    //     foreach ($allUsers as $user) {
    //         if ($user->id === $loggedInUser->id || in_array($user->id, $excludedIds)) {
    //             continue; // Skip the logged-in user and excluded users
    //         }

    //         // Get the current user's preferences
    //         $userPreferences = $user->preferences->keyBy('question_id');

    //         // Step 5: Calculate matches
    //         $totalQuestions = count($loggedInUserPreferences);
    //         $matchingCount = 0;

    //         foreach ($loggedInUserPreferences as $questionId => $loggedInPreference) {
    //             if (isset($userPreferences[$questionId])) {
    //                 // Decode the answers from JSON string to array
    //                 $loggedInAnswers = json_decode($loggedInPreference->answer, true);
    //                 $userAnswers = json_decode($userPreferences[$questionId]->answer, true);

    //                 // Check for matches
    //                 $matches = count(array_intersect($loggedInAnswers, $userAnswers));
    //                 if ($matches > 0) {
    //                     $matchingCount++;
    //                 }
    //             }
    //         }

    //         // Step 6: Check if the matching count is at least 50%
    //         if ($totalQuestions > 0 && $matchingCount / $totalQuestions >= 0.5) {
    //             $user->match_percentage = $matchingCount / $totalQuestions * 100; // Add match percentage
    //             $matchingUsers[] = $user; // Add user to matching users
    //         }
    //     }

    //     // Step 7: Limit to 20 users and return as JSON
    //     $limitedMatchingUsers = collect($matchingUsers)->sortByDesc('match_percentage')->take(20);

    //     return $limitedMatchingUsers->values()->all();
    // }
    public function getMatchedProfiles($request)
    {
        $loggedInUser = auth()->user();

        // Check if the logged-in user has preferences
        // if ($loggedInUser->preferences->isEmpty()) {
        //     throw new BadRequestException('Not enough users currently.');
        // }
        $userLatitude = $loggedInUser->latitude;
        $userLongitude = $loggedInUser->longitude;
        // Step 1: Load all users and their preferences in one go
        $allUsers = User::with('preferences');

        // Apply Age Range Filter
        if ($request->has('age_from') && $request->has('age_to')) {
            $minAge = $request->input('age_from');
            $maxAge = $request->input('age_to');
            $allUsers->whereBetween('age', [$minAge, $maxAge]);  // Assuming 'age' is a field in the user table
        }

        // Apply Band Filter
        if ($request->has('ring')) {
            $band = $request->input('ring');
            $allUsers->where('ring', $band);  // Adjust this if 'band' is part of user preferences or elsewhere
        }

        if ($loggedInUser->ring == 'white') {
            $band = 'green';
            $allUsers->where('ring', $band);  // Adjust this if 'band' is part of user preferences or elsewhere
        }
        if ($loggedInUser->ring == 'green') {
            $band = 'white';
            $allUsers->where('ring', $band);  // Adjust this if 'band' is part of user preferences or elsewhere
        }
        if ($loggedInUser->ring == 'tan') {
            $band = 'tan';
            $allUsers->where('ring', $band);  // Adjust this if 'band' is part of user preferences or elsewhere
        }

        // Apply Full Name Filter
        if ($request->has('search')) {
            $search = $request->input('search');
            $allUsers->where(function ($query) use ($search) {
                $query->where(function ($q) use ($search) {
                    $q->where('first_name', 'like', '%' . $search . '%')
                        ->orWhere('last_name', 'like', '%' . $search . '%')
                        ->orWhere('email', 'like', '%' . $search . '%')
                        ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . $search . '%');
                });
            });
        }

        // Apply Radius Filter
        $latitude = $userLatitude;
        $longitude = $userLongitude;
        $radius = $request->input('radius', 10); // radius in kilometers or miles

        // Haversine formula to calculate the distance
        // $allUsers->selectRaw("
        //     users.*,
        //     ( 6371 * acos( cos( radians(?) ) * cos( radians( users.latitude ) ) * cos( radians( users.longitude ) - radians(?) ) + sin( radians(?) ) * sin( radians( users.latitude ) ) ) ) AS distance",
        //     [$latitude, $longitude, $latitude]
        // );

        // Filter by radius (if distance is less than the radius)
        // $allUsers->havingRaw("distance <= ?", [$radius]);

        // Get the filtered users
        // $allUsersWhoseGhostModeIsOn = $allUsers->where('live_location', 1)->pluck('id')->toArray();
        $allUsers = $allUsers->get();
        $allUsersWhoseGhostModeIsOn = $allUsers->where('live_location', 1)->pluck('id')->toArray();

        // dd($allUsersWhoseGhostModeIsOn);
        // Step 2: Prepare to collect matched users
        $matchingUsers = [];

        // Step 3: Get the logged-in user's preferences
        $loggedInUserPreferences = $loggedInUser->preferences->keyBy('question_id');
        $userLocations = UserLocation::selectRaw("
        user_locations.user_id AS id,
        user_locations.latitude,
        user_locations.longitude,
        user_locations.radius,
        ( 6371 * acos( cos( radians(?) ) * cos( radians( user_locations.latitude ) ) * cos( radians( user_locations.longitude ) - radians(?) ) + sin( radians(?) ) * sin( radians( user_locations.latitude ) ) ) ) AS distance",
            [$latitude, $longitude, $latitude]
        )
            ->whereIn('user_locations.user_id', $allUsersWhoseGhostModeIsOn)  // Filter users based on ghost mode
            ->havingRaw("distance >= user_locations.radius")  // Ensure distance is within the user's radius
            ->pluck('id')->toArray();
        // Step 4: Get the user's friends and sent/received friend requests
        $friendsIds = DB::table('friends')
            ->where('user_id', $loggedInUser->id)
            ->pluck('friend_id')
            ->toArray();

        $friendRequestsSentIds = DB::table('friend_requests')
            ->where('sender_id', $loggedInUser->id)
            ->pluck('receiver_id')
            ->toArray();

        $friendRequestsReceivedIds = DB::table('friend_requests')
            ->where('receiver_id', $loggedInUser->id)
            ->pluck('sender_id')
            ->toArray();

        // Combine all IDs to exclude from matches
        $excludedIds = array_merge($friendsIds, $friendRequestsSentIds, $friendRequestsReceivedIds, $userLocations);
        $excludedIds = array_unique($excludedIds);
        // Get all cancelled users' IDs
        $cancelledUserIds = DB::table('cancelled_users')
            ->where('user_id', $loggedInUser->id) // Get users where the logged-in user has cancelled
            ->where('created_at', '>=', Carbon::now()->subDay()) // Only include cancellations from the last 24 hours
            ->pluck('cancelled_user') // Get the IDs of cancelled users
            ->toArray();

        foreach ($allUsers as $user) {
            if ($user->id === $loggedInUser->id || in_array($user->id, $excludedIds) || in_array($user->id, $cancelledUserIds)) {
                continue; // Skip the logged-in user, excluded users, and cancelled users
            }

            // Get the current user's preferences
            $userPreferences = $user->preferences->keyBy('question_id');

            // Step 5: Calculate matches
            $totalQuestions = count($loggedInUserPreferences);
            $matchingCount = 0;

            foreach ($loggedInUserPreferences as $questionId => $loggedInPreference) {
                if (isset($userPreferences[$questionId])) {
                    // Decode the answers from JSON string to array
                    $loggedInAnswers = json_decode($loggedInPreference->answer, true);
                    $userAnswers = json_decode($userPreferences[$questionId]->answer, true);

                    // Check for matches
                    $matches = count(array_intersect($loggedInAnswers, $userAnswers));
                    if ($matches > 0) {
                        $matchingCount++;
                    }
                }
            }

            // Step 6: Check if the matching count is at least 50%
            if ($totalQuestions > 0 && $matchingCount / $totalQuestions >= 0.5) {
                $user->match_percentage = $matchingCount / $totalQuestions * 100; // Add match percentage
                $matchingUsers[] = $user; // Add user to matching users
            }
        }

        // Step 7: Limit to 20 users and return as JSON
        $limitedMatchingUsers = collect($matchingUsers)->sortByDesc('match_percentage')->take(20);

        return $limitedMatchingUsers->values()->all();
    }

    // public function getMatchedProfilesWithFilters($request)
    // {
    //     $loggedInUser = auth()->user();

    //     // Check if the logged-in user has preferences
    //     if ($loggedInUser->preferences->isEmpty()) {
    //         throw new BadRequestException('Not enough users currently.');
    //     }

    //     // Step 1: Load all users and their preferences in one go
    //     $query = User::with('preferences');

    //     // Step 2: Apply filters from the request (optional)
    //     if ($request->has('age_from') && $request->has('age_to')) {
    //         $query->whereBetween('age', [$request->input('age_from'), $request->input('age_to')]);
    //     }

    //     if ($request->has('location')) {
    //         $query->where('location', 'like', '%' . $request->input('location') . '%');
    //     }

    //     if ($request->has('gender')) {
    //         $query->where('gender', $request->input('gender'));
    //     }

    //     // Additional filters can be added here based on user preferences
    //     // Example: filtering based on a specific preference
    //     if ($request->has('preference_question_id') && $request->has('preference_answer')) {
    //         $query->whereHas('preferences', function ($q) use ($request) {
    //             $q->where('question_id', $request->input('preference_question_id'))
    //                 ->where('answer', 'like', '%' . $request->input('preference_answer') . '%');
    //         });
    //     }

    //     // Get all users based on the filtered query
    //     $allUsers = $query->get();

    //     // Step 3: Prepare to collect matched users
    //     $matchingUsers = [];

    //     // Step 4: Get the logged-in user's preferences
    //     $loggedInUserPreferences = $loggedInUser->preferences->keyBy('question_id');

    //     // Step 5: Get the user's friends and sent/received friend requests
    //     $friendsIds = DB::table('friends')
    //         ->where('user_id', $loggedInUser->id)
    //         ->pluck('friend_id')
    //         ->toArray();

    //     $friendRequestsSentIds = DB::table('friend_requests')
    //         ->where('sender_id', $loggedInUser->id)
    //         ->pluck('receiver_id')
    //         ->toArray();

    //     $friendRequestsReceivedIds = DB::table('friend_requests')
    //         ->where('receiver_id', $loggedInUser->id)
    //         ->pluck('sender_id')
    //         ->toArray();

    //     // Combine all IDs to exclude from matches
    //     $excludedIds = array_merge($friendsIds, $friendRequestsSentIds, $friendRequestsReceivedIds);

    //     foreach ($allUsers as $user) {
    //         if ($user->id === $loggedInUser->id || in_array($user->id, $excludedIds)) {
    //             continue; // Skip the logged-in user and excluded users
    //         }

    //         // Get the current user's preferences
    //         $userPreferences = $user->preferences->keyBy('question_id');

    //         // Step 6: Calculate matches
    //         $totalQuestions = count($loggedInUserPreferences);
    //         $matchingCount = 0;

    //         foreach ($loggedInUserPreferences as $questionId => $loggedInPreference) {
    //             if (isset($userPreferences[$questionId])) {
    //                 // Decode the answers from JSON string to array
    //                 $loggedInAnswers = json_decode($loggedInPreference->answer, true);
    //                 $userAnswers = json_decode($userPreferences[$questionId]->answer, true);

    //                 // Check for matches
    //                 $matches = count(array_intersect($loggedInAnswers, $userAnswers));
    //                 if ($matches > 0) {
    //                     $matchingCount++;
    //                 }
    //             }
    //         }

    //         // Step 7: Check if the matching count is at least 50%
    //         if ($totalQuestions > 0 && $matchingCount / $totalQuestions >= 0.5) {
    //             $user->match_percentage = $matchingCount / $totalQuestions * 100; // Add match percentage
    //             $matchingUsers[] = $user; // Add user to matching users
    //         }
    //     }

    //     // Step 8: Limit to 20 users and return as JSON
    //     $limitedMatchingUsers = collect($matchingUsers)->sortByDesc('match_percentage')->take(20);

    //     return $limitedMatchingUsers->values()->all();
    // }

    public function getMatchedProfilesWithFilters($request)
    {
        $loggedInUser = auth()->user();

        // Check if the logged-in user has location data (assuming these are in the user's record)
        $userLatitude = $loggedInUser->latitude;
        $userLongitude = $loggedInUser->longitude;

        // Step 1: Initialize the query for fetching users
        $query = User::with('preferences');
        $query->where('type', "!=", "admin");
        $query->where('is_location_enable', "=", 1);
        // Step 2: Apply radius-based search if latitude/longitude are provided
        if ($request->has('latitude') && $request->has('longitude')) {
            // Use the latitude and longitude from the request
            $searchLatitude = $request->input('latitude');
            $searchLongitude = $request->input('longitude');
        } else {
            // Fall back to logged-in user's latitude and longitude
            $searchLatitude = $userLatitude;
            $searchLongitude = $userLongitude;
        }

        // Default radius is 10 km if not provided in the request in feets
        $radius = $request->input('radius', 10);

        // Apply the radius-based search using the Haversine formula
        $query->selectRaw("
        *,
        ( 6371 * acos(
            cos( radians(?) ) * cos( radians(latitude) ) * cos( radians(longitude) - radians(?) ) +
            sin( radians(?) ) * sin( radians(latitude) )
        ) ) AS distance", [$searchLatitude, $searchLongitude, $searchLatitude])
            ->having('distance', '<=', $radius);  // Filter users within the specified radius

        // Step 3: Apply additional filters (age, gender, etc.)
        if ($request->has('age_from') && $request->has('age_to')) {
            $query->whereBetween('age', [$request->input('age_from'), $request->input('age_to')]);
        }


        if ($request->has('gender')) {
            $query->where('gender', $request->input('gender'));
        }
        if ($request->has('ring')) {
            $query->where('ring', $request->input('ring'));
        }


        // Step 4: Apply dynamic preference filters from the request
        if ($request->has('preferences')) {
            $preferences = $request->input('preferences');  // Array of preferences (question_id + answer)

            foreach ($preferences as $preference) {

                // Each preference should have a 'question_id' and 'answer' (array of selected question_option_ids)
                if (isset($preference['question_id']) && isset($preference['answer'])) {
                    if (is_array($preference['answer'])) {
                        $preference['answer'] = array_map('intval', $preference['answer']);
                    }
                    // $preference['answer'] = array_map('intval', $preference['answer']); // Convert all values in the answer array to integers

                    $query->whereHas('preferences', function ($q) use ($preference) {
                        $q->where('question_id', $preference['question_id'])
                            ->whereJsonContains('answer', $preference['answer']);  // Expecting $preference['answer'] to be an array of integers
                    });
                }
            }
        }
        if ($request->has('height_from') && $request->has('height_to')) {
            // Convert the height range inputs from "4'1\"" to inches
            $heightFrom = $this->convertHeightToInches($request->input('height_from'));  // E.g., 49 inches
            $heightTo = $this->convertHeightToInches($request->input('height_to'));      // E.g., 65 inches

            // Log the converted heights for debugging purposes
            \Log::debug("Height From (in inches): $heightFrom, Height To (in inches): $heightTo");

            // Query the database to get users with height in the given range (in inches)
            $query->whereRaw("(
        CAST(SUBSTRING_INDEX(SUBSTRING_INDEX(height, '\'', 1), '\'', -1) AS UNSIGNED) * 12 +
        CAST(SUBSTRING_INDEX(height, '\'', -1) AS UNSIGNED)
    ) BETWEEN ? AND ?", [$heightFrom, $heightTo]);
        }
        // Step 5: Exclude the logged-in user from the results
        $query->where('id', '!=', $loggedInUser->id);
        $allUsersWhoseGhostModeIsOnCheck = $query->get();

        $allUsersWhoseGhostModeIsOn = $allUsersWhoseGhostModeIsOnCheck->where('live_location', 0)->pluck('id')->toArray();
        $userLocations = UserLocation::selectRaw("
        user_locations.user_id AS id,
        user_locations.latitude,
        user_locations.longitude,
        user_locations.radius,
        ( 6371 * acos( cos( radians(?) ) * cos( radians( user_locations.latitude ) ) * cos( radians( user_locations.longitude ) - radians(?) ) + sin( radians(?) ) * sin( radians( user_locations.latitude ) ) ) ) AS distance",
            [$searchLatitude, $searchLongitude, $searchLatitude]
        )
            ->whereIn('user_locations.user_id', $allUsersWhoseGhostModeIsOn)  // Filter users based on ghost mode
            ->havingRaw("distance <= user_locations.radius")  // Ensure distance is within the user's radius
            ->pluck('id')->toArray();
        // Step 6: Get all users based on the filtered query
        $allUsers = $query->whereNotIn('id', $userLocations);
        $allUsers = $query->get();


        $matchingUsers = [];// Step 7: Format the users to include the distance in the response


        $matchingUsers = $allUsers->map(function ($user) use ($searchLatitude, $searchLongitude) {
            // Calculate the distance using the Haversine formula again to ensure it's accurate
            $distance = $this->calculateDistance(
                $searchLatitude,
                $searchLongitude,
                $user->latitude,
                $user->longitude
            );

            // Add the distance to the user data
            $user->distance = $distance;

            return $user;
        });
        return $matchingUsers;
    }

    private function convertHeightToInches($height)
    {
        // Match the format "4'1\"" where one single quote and one double quote exist
        if (preg_match("/(\d+)\'(\d+)\"/", $height, $matches)) {
            $feet = (int) $matches[1];  // Feet part (before the single quote)
            $inches = (int) $matches[2];  // Inches part (after the single quote and before the double quote)

            // Convert to inches: (feet * 12) + inches
            return ($feet * 12) + $inches;
        }

        return 0;  // Return 0 if the format is invalid
    }

    private function calculateDistance($lat1, $lon1, $lat2, $lon2)
    {
        $earthRadius = 6371;  // Radius of the Earth in kilometers

        $dLat = deg2rad($lat2 - $lat1);  // Difference in latitude
        $dLon = deg2rad($lon2 - $lon1);  // Difference in longitude

        $a = sin($dLat / 2) * sin($dLat / 2) +
            cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
            sin($dLon / 2) * sin($dLon / 2);

        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

        return $earthRadius * $c;  // Distance in kilometers
    }






    public function update($request, $question)
    {
        $question->question_text = $request->question_text;
        return $question;
    }
}
