<?php

namespace App\Services;

use App\Models\Friend;
use App\Models\Post;
use App\Models\Question;
use App\Models\QuestionOption;
use App\Models\StoreCategory;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Support\Facades\DB;


/**
 * Class JsonResponseService
 * @package App\Services
 */
class QuestionOptionService extends BaseService
{
    public function index()
    {
        $query = Question::orderBy('id', 'desc');
        $posts = $query->paginate($this->pagination);
        return $posts;
    }


    public function show($id)
    {
        $question = Question::where('id', $id)->first();
        return $question;
    }

    public function store($request)
    {
        $questionOption = new QuestionOption();
        $questionOption->question_id = $request->question_id;
        $questionOption->option_text = $request->option_text;
        $questionOption->save();
        return $questionOption;
    }

    public function update($request, $question)
    {
        $question->question_text = $request->question_text;
        return $question;
    }
}
