<?php

namespace App\Services;

use App\Models\Friend;
use App\Models\Post;
use App\Models\Question;
use App\Models\QuestionCategory;
use App\Models\QuestionOption;
use App\Models\StoreCategory;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Support\Facades\DB;


/**
 * Class JsonResponseService
 * @package App\Services
 */
class QuestionService extends BaseService
{
    public function index()
    {
        $query = Question::orderBy('id', 'desc');
        $posts = $query->paginate($this->pagination);
        return $posts;
    }

    public function categoryWise()
    {
        $questions = QuestionCategory::with('questions', 'questions.questionOptions')->whereNot('id', 4)->orderBy('sort_index')->get();
        return $questions;
    }
    public function preferences()
    {
        $questions = QuestionCategory::with('questions', 'questions.questionOptions')->where('id', 4)->first();
        return $questions;
    }

    public function heightOption()
    {
        $heightQuestionId = Question::where('question_text', "Height")->first();
        $questionOptions = QuestionOption::where('question_id', $heightQuestionId->id)->get();
        return $questionOptions;
    }
    public function carrerFieldOption()
    {
        $heightQuestionId = Question::where('question_text', "Career Field")->first();
        $careerFieldOptions = QuestionOption::where('question_id', $heightQuestionId->id)->get();
        return $careerFieldOptions;
    }

    public function educationLevelOption()
    {
        $heightQuestionId = Question::where('question_text', "Education Level")->first();
        $educationLevelOptions = QuestionOption::where('question_id', $heightQuestionId->id)->get();
        return $educationLevelOptions;
    }


    public function show($id)
    {
        $question = Question::where('id', $id)->first();
        return $question;
    }

    public function store($request)
    {
        $question = new Question();
        $question->question_text = $request->question_text;
        $question->question_type = $request->question_type;
        $question->allowed_type = $request->allowed_type;
        $question->question_category_id = $request->question_category_id;
        $question->save();
        return $question;
    }

    public function update($request, $question)
    {
        $question->question_text = $request->question_text;
        return $question;
    }
}
