<?php

namespace App\Services;

use App\Models\Product;
use App\Models\Rating;
use App\Models\Store;
use App\Models\StoreCategory;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\DB;
use Mockery\Exception;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class RatingService extends BaseService
{
    public function store($request)
    {
        $rating = new Rating();
        $rating->rating = $request->rating;
        $rating->review = $request->review;
        $rating->product_id = $request->product_id;
        $rating->user_id = auth()->user()->id;
        $rating->save();
        return $rating;
    }
    public function update($request, $id)
    {
        $rating = Rating::find($id);
        $rating->rating = $request->rating;
        $rating->review = $request->review;
        $rating->save();
        return $rating;
    }
    public function checkRating($product_id, $user_id)
    {
        $rating = Rating::where('product_id', $product_id)->where('user_id', $user_id)->first();
        return $rating;
    }

}
