<?php

namespace App\Services;

use App\Models\Cart;
use App\Models\RecentlyViewedProduct;
use App\Models\StoreCategory;
use App\Models\User;
use App\Models\Wishlist;
use App\Services\Common\BaseService;
use Illuminate\Http\Resources\Json\JsonResource;
use Mockery\Exception;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class RecentlyViewedProductService extends BaseService
{
    public function index()
    {
        $recentlyViewedProducts = RecentlyViewedProduct::with('product')
            ->where('user_id', auth()->user()->id)
            ->orderBy('updated_at', 'desc');
        $recentlyViewedProducts = $recentlyViewedProducts->paginate($this->pagination);
        return $recentlyViewedProducts;
    }

    public function show($id)
    {
        $user = User::where('id', $id)->first();
        return $user;
    }


    public function delete($wishlist)
    {
        return $wishlist->delete();

    }

    public function store($product_id)
    {
        $user = auth()->user();

        // Check if the product already exists in the user's recently viewed products
        $existingProduct = RecentlyViewedProduct::where('user_id', $user->id)
            ->where('product_id', $product_id)
            ->first();

        if ($existingProduct) {
            // If the product already exists, update its `created_at` timestamp to current time
            $existingProduct->touch(); // Updates `created_at` and `updated_at` timestamps
            return $existingProduct;
        }

        // Check if user has 5 recently viewed products
        $recentlyViewedProducts = RecentlyViewedProduct::where('user_id', $user->id)
            ->orderBy('created_at', 'asc') // Order by oldest first
            ->get();

        if ($recentlyViewedProducts->count() >= 5) {
            // Delete the oldest product
            $recentlyViewedProducts->first()->delete();
        }

        // Add the new product to recently viewed
        $recentlyViewedProduct = new RecentlyViewedProduct();
        $recentlyViewedProduct->user_id = $user->id;
        $recentlyViewedProduct->product_id = $product_id;
        $recentlyViewedProduct->save();

        return $recentlyViewedProduct;
    }


    public function accountStatus($userId)
    {
        $user = User::find($userId);
        $user->status = ($user->status == 1) ? 0 : 1;
        $user->save();
        return $user;
    }
}
