<?php

namespace App\Services;

use App\Models\Category;
use App\Models\Size;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Http\Resources\Json\JsonResource;
use Mockery\Exception;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class SizeService extends BaseService
{
    public function index()
    {
        $categories = Category::with('image', 'products')
            ->when(request()->filled('search'), function ($q) {
                $q->where(function ($q) {
                    $q->where('name', 'like', '%' . request("search") . '%');
                });
            })
            ->when(request()->filled('status') && request('status') != 0, function ($q) {
                $q->where('status', request("status"));
            })
            ->when(request()->filled('fromDate'), function ($q) {
                $q->whereDate('created_at', '>=', request('fromDate'))
                    ->whereDate('created_at', '<=', request('toDate'));
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $categories;
    }
    public function all()
    {
        $sizes = Size::where('status', 1)
            ->orderBy('id', 'desc')
            ->get();
        return $sizes;
    }

    public function withoutPagination()
    {
        $categories = Category::where('status', Category::STATUS_ACTIVE)->orderBy('id', 'desc')
            ->get();
        return $categories;
    }
    public function show($id)
    {
        $category = Category::where('id', $id)->first();
        return $category;
    }

    public function store($request)
    {
        $category = Category::create([
            'name' => $request->name,
            'status' => $request->status,
        ]);
        if ($request->hasFile('image')) {
            storeImage($request, 'image', Category::IMAGES_DIRECTORY, $category);
        }
        return $category;
    }

    public function update($request, $category)
    {
        $category->name = $request->name;
        $category->status = $request->status;
        $category->save();
        if ($request->hasFile('image')) {
            storeImage($request, 'image', Category::IMAGES_DIRECTORY, $category);
        }
        return $category;
    }


    public function changeStatus($category_id)
    {
        $category = Category::find($category_id);
        $category->status = ($category->status == Category::STATUS_ACTIVE) ? Category::STATUS_INACTIVE : Category::STATUS_ACTIVE;
        $category->save();
        return $category;
    }
}
