<?php

namespace App\Services;

use App\Models\User;
use App\Models\UserAnswer;
use App\Notifications\SendAdminNotification;
use App\Services\Common\BaseService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class UserService extends BaseService
{
    public function index($type = 'user')
    {
        $users = User::where('type', '=', $type)
            ->when(request()->filled('status') && request('status') != 2, function ($q) {
                $q->whereStatus(request('status'));
            })
            ->when(request()->filled('search'), function ($q) {

                $q->where(function ($q) {
                    $q->where('first_name', 'like', '%' . request("search") . '%')
                        ->orWhere('last_name', 'like', '%' . request("search") . '%')
                        ->orWhere('email', 'like', '%' . request("search") . '%')
                        ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . request("search") . '%');

                });
            })
            ->when(request()->filled('from'), function ($q) {
                $q->whereDate('created_at', '>=', request('from'))->whereDate('created_at', '<=', request('to'));
            })
            ->when(request()->filled('sort'), function ($q) {

                $q->where('status', '=', request('sort'));

            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $users;
    }

    public function show($id)
    {
        $user = User::with(['images', 'verificationimages', 'socialLinks', 'userAnswers', 'userAnswers.question.category'])->find($id);
        return $user;
    }



    public function accountStatus($userId)
    {
        $user = User::find($userId);
        $user->status = ($user->status == 1) ? 0 : 1;
        $user->save();
        return $user;
    }

    public function verificationStatus($userId)
    {
        $user = User::find($userId);
        $user->is_verified = ($user->is_verified == 1) ? 0 : 1;
        $user->save();
        $title = "Your profile has been verified!";
        $body = $user->id;
        $data = [
            "user" => $user,
            "title" => $title,
            "body" => $user->id,
        ];
        sendNotificationToUser($title, $body, $data, $user);
        return $user;
    }


    public function getMatchingProfiles()
    {
        $user = auth()->user();
        $userAnswers = UserAnswer::where('user_id', $user->id)->get();
        $similarProfiles = User::whereHas('userAnswers', function ($query) use ($userAnswers) {
            foreach ($userAnswers as $userAnswer) {
                $query->orWhere(function ($q) use ($userAnswer) {
                    $q->where('question_id', $userAnswer->question_id)
                        ->where('answer_id', $userAnswer->answer_id);
                });
            }
        })
            ->where('id', '!=', $user->id) // Exclude the current user
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $similarProfiles;
    }
}
