<?php

namespace App\Services;

use App\Models\Cart;
use App\Models\StoreCategory;
use App\Models\User;
use App\Models\Wishlist;
use App\Services\Common\BaseService;
use Illuminate\Http\Resources\Json\JsonResource;
use Mockery\Exception;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class WishlistService extends BaseService
{
    public function index()
    {
        $query = Wishlist::with('product')
            ->where('user_id', auth()->user()->id)
            ->when(request()->filled('search'), function ($query) {
                // If search term is provided, filter by product name
                $query->whereHas('product', function ($query) {
                    $searchTerm = request('search');
                    $query->where('name', 'LIKE', "%{$searchTerm}%"); // Search by product name
                });
            })
            ->when(request()->filled('categories'), function ($query) {
                // If categories are provided, filter by category IDs
                $query->whereHas('product', function ($query) {
                    $query->whereIn('category_id', request('categories'));
                });
            })
            ->orderBy('id', 'desc');
        $wishlist = $query->paginate($this->pagination);
        return $wishlist;
    }

    public function show($id)
    {
        $user = User::where('id', $id)->first();
        return $user;
    }

    public function update($request, $cart)
    {
        $cart->quantity = $request->quantity;
        $cart->save();
        return $cart;
    }

    public function checkWishlistItem($product_id)
    {
        return Wishlist::where('user_id', auth()->user()->id)->where('product_id', $product_id)->first();
    }

    public function delete($wishlist)
    {
        return $wishlist->delete();

    }

    public function store($product_id)
    {
        $wishlist = new Wishlist();
        $wishlist->user_id = auth()->user()->id;
        $wishlist->product_id = $product_id;
        $wishlist->save();
        return $wishlist;
    }


    public function accountStatus($userId)
    {
        $user = User::find($userId);
        $user->status = ($user->status == 1) ? 0 : 1;
        $user->save();
        return $user;
    }
}
