<?php

use App\Models\Order;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_details', function (Blueprint $table) {
            $table->id();
            $table->float('price');
            $table->integer('quantity');
            $table->enum('status', [Order::PENDING, Order::ACCEPTED, Order::REJECTED, Order::DELIVERED, Order::PROCESSED])->default(Order::PENDING);
            $table->foreignId('product_id')->references('id')->on('products')->cascadeOnDelete()->default(null);
            $table->foreignId('order_id')->references('id')->on('orders')->cascadeOnDelete()->default(null);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_details');
    }
};
