<?php

use App\Models\UserSocialLink;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_social_links', function (Blueprint $table) {
            $table->id();
            $table->string('link');
            $table->enum('type', [UserSocialLink::TYPE_FACEBOOK, UserSocialLink::TYPE_INSTAGRAM, UserSocialLink::TYPE_LINKEDIN, UserSocialLink::TYPE_QUORA, UserSocialLink::TYPE_REDDIT, UserSocialLink::TYPE_SNAPCHAT, UserSocialLink::TYPE_TIKTOK, UserSocialLink::TYPE_TWITTER]);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_social_links');
    }
};
