<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cancelled_users', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("cancelled_user");
            $table->foreign(columns: 'cancelled_user')->references('id')->on('users')->onDelete('cascade');
            $table->unsignedBigInteger("user_id");
            $table->foreign(columns: 'user_id')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cancelled_users');
    }
};
