<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tap_to_matches', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("tapped_user");
            $table->foreign( 'tapped_user')->references('id')->on('users')->onDelete('cascade');
            $table->unsignedBigInteger("user_id");
            $table->foreign( 'user_id')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tap_to_matches');
    }
};
