<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Add the 'avatar_id' column if it doesn't exist already (nullable)
            $table->unsignedBigInteger('avatar_id')->nullable()->after('nfc_tag'); // Ensure 'some_column' is the column after which this field should be placed.

            // Add foreign key constraint
            $table->foreign('avatar_id')->references('id')->on('avatars')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Drop the foreign key constraint first (if any)
            $table->dropForeign(['avatar_id']);

            // Drop the 'avatar_id' column
            $table->dropColumn('avatar_id');
        });
    }
};
