<?php

use App\Http\Controllers\Admin\AvatarController;
use App\Http\Controllers\Admin\BannerController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\EventController;
use App\Http\Controllers\Admin\PaymentLogController;
use App\Http\Controllers\Admin\QuestionOptionController;
use App\Http\Controllers\Api\CategoryController as ApiCategoryController;
use App\Http\Controllers\Admin\CommissionController;
use App\Http\Controllers\Admin\DeliveryChargeController;
use App\Http\Controllers\Api\DeliveryChargeController as ApiDeliveryChargeController;
use App\Http\Controllers\Admin\QuestionController;
use App\Http\Controllers\Api\CartController;
use App\Http\Controllers\Api\AvatarController as ApiAvatarController;

use App\Http\Controllers\Api\FriendController;
use App\Http\Controllers\Api\OrderController;
use App\Http\Controllers\Admin\OrderController as AdminOrderController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Api\PreferenceController;
use App\Http\Controllers\Api\ProductController as ApiProductController;
use App\Http\Controllers\Api\RatingController;
use App\Http\Controllers\Api\RecentlyViewedProductController;
use App\Http\Controllers\Api\ReportController;
use App\Http\Controllers\Admin\ReportController as AdminReportController;
use App\Http\Controllers\Admin\SizeController;
use App\Http\Controllers\Api\StripeController;
use App\Http\Controllers\Api\WishListController;
use App\Http\Controllers\Api\ChatController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AuthController as AdminAuthController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\PushNotificationController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Api\UserController as ApiUserController;
use App\Http\Controllers\Admin\FeedbackController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\FeedbackController as ApiFeedbackController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware(['auth:sanctum', 'admin'])->get('/user', function (Request $request) {
    return $request->user();
});
Route::post('/reset/password', [AuthController::class, 'reset']);
Route::post('/verify/code', [AuthController::class, 'verifyCode']);
Route::post('/set/password', [AuthController::class, 'setPassword']);

Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    //Notification
    Route::get('notification/unread/list', [NotificationController::class, 'unread']);
    Route::get('notification/read/list', [NotificationController::class, 'read']);
    Route::get('notification/all/list', [NotificationController::class, 'index']);
    Route::get('notification/all/readNotifications', [NotificationController::class, 'read']);
    Route::post('notification/all/read', [NotificationController::class, 'mark']);
    Route::post('notification/read', [NotificationController::class, 'individual']);
    Route::post('notification/unread', [NotificationController::class, 'markAsUnread']);
    Route::get('unread/notification/count', [NotificationController::class, 'unreadNotificationCount']);
    Route::get('unread/message/count', [NotificationController::class, 'unreadMessageCount']);
});

Route::prefix('admin')->group(function () {
    Route::middleware(['admin'])->group(function () {
        Route::post('/login', [AdminAuthController::class, 'login']);
    });
    Route::middleware(['auth:sanctum', 'admin'])->group(function () {
        // Logout
        Route::post('/logout', [AuthController::class, 'logout']);
        // Admin Profile
        Route::get('profile', [AdminAuthController::class, 'profile']);
        Route::post('profile/update', [AdminAuthController::class, 'update']);
        Route::post('change-password', [AdminAuthController::class, 'updatePassword']);
        // Dashboard
        Route::get('dashboard/stats', [AdminAuthController::class, 'dashboardStats']);
        Route::get('dashboard/chartStats', [AdminAuthController::class, 'chartStats']);
        Route::get('dashboard/userStats', [AdminAuthController::class, 'userStats']);
        Route::get('chart/data', [AdminAuthController::class, 'chartData']);
        Route::get('chart/filter', [AdminAuthController::class, 'filterChartData']);
        // User
        Route::get('users', [UserController::class, 'index']);
        Route::post('user/{user}/status', [UserController::class, 'status']);
        Route::post('user/{user}/verificationStatus', [UserController::class, 'verificationStatus']);
        Route::get('user/{user}', [UserController::class, 'show']);
        // Category
        Route::get('category/categories', action: [CategoryController::class, 'index']);
        Route::post('category/category', [CategoryController::class, 'store']);
        Route::post('category/{category}/status', [CategoryController::class, 'changeStatus']);
        Route::get('category/{category}', [CategoryController::class, 'show']);
        Route::get('category/{category}/products', [CategoryController::class, 'products']);
        Route::post('category/{category}/update', [CategoryController::class, 'update']);
        Route::get('category/categories/withoutPagination', [CategoryController::class, 'withoutPagination']);
        //Delivery Charges
        Route::get('deliveryCharge/deliveryCharges', [DeliveryChargeController::class, 'index']);
        Route::post('deliveryCharge/deliveryCharge', [DeliveryChargeController::class, 'store']);
        // Product
        Route::post('product/create', [ProductController::class, 'store']);
        Route::get('product/deleteImage/{image}', [ProductController::class, 'deleteProductImage']);
        Route::post('product/{product}/update', [ProductController::class, 'update']);
        Route::post('product/{product}/status', [ProductController::class, 'changeStatus']);
        Route::get('product/products', [ProductController::class, 'index']);
        Route::get('product/{product}', [ProductController::class, 'show']);
        //Sizes
        Route::get('size/sizes', [SizeController::class, 'all']);
        // Banner
        Route::get('banner/banners', [BannerController::class, 'index']);
        Route::post('banner/banner', [BannerController::class, 'store']);
        Route::post('banner/{banner}/delete', [BannerController::class, 'delete']);
        Route::get('banner/{banner}', [BannerController::class, 'show']);
        Route::post('banner/{banner}/update', [BannerController::class, 'update']);
        // Event
        Route::get('event/events', [EventController::class, 'index']);
        Route::post('event/event', [EventController::class, 'store']);
        Route::post('event/{event}/delete', [EventController::class, 'delete']);
        Route::get('event/{event}', [EventController::class, 'show']);
        Route::post('event/{event}/update', [EventController::class, 'update']);
        // Question
        Route::get('question/questions', [QuestionController::class, 'index']);
        Route::post('question/question', [QuestionController::class, 'store']);
        Route::get('question/{question}', [QuestionController::class, 'show']);
        Route::post('question/{question}/update', [QuestionController::class, 'update']);

        // Question Options
        Route::get('question/questions', [QuestionController::class, 'index']);
        Route::post('questionOption/questionOption', [QuestionOptionController::class, 'store']);
        Route::get('question/{question}', [QuestionController::class, 'show']);
        Route::post('question/{question}/update', [QuestionController::class, 'update']);
        // Avatar
        Route::get('avatars', [AvatarController::class, 'index']);
        Route::post('avatars', [AvatarController::class, 'store']);
        Route::get('avatars/{avatar}', [AvatarController::class, 'show']);
        Route::post('avatars/{avatar}/update', [AvatarController::class, 'update']);
        // Commissions
        Route::get('commission/commissions', [CommissionController::class, 'index']);
        Route::post('commission/store', [CommissionController::class, 'store']);
        // Reports
        Route::get('report/reports', [AdminReportController::class, 'index']);
        Route::get('report/{report}', [AdminReportController::class, 'show']);
        Route::post('report/{report}/status', [AdminReportController::class, 'status']);
        //Order Module
        Route::get('order/orders', [AdminOrderController::class, 'index']);
        Route::post('order/changeStatus', [AdminOrderController::class, 'updateStatus']);
        Route::get('order/orders/{id}', [AdminOrderController::class, 'userOrders']);
        Route::get('order/{order}', [AdminOrderController::class, 'show']);
        //Payment Log Module
        Route::get('paymentLog/paymentLogs', [PaymentLogController::class, 'index']);



        // Push Notification
        Route::post('send/push-notification', [PushNotificationController::class, 'send']);
        // Feedbacks
        Route::get('feedbacks', [FeedbackController::class, 'index']);
        Route::get('feedbacks/{feedback}', [FeedbackController::class, 'show']);
        // Pages
        Route::get('pages', [PageController::class, 'index']);
        Route::post('page', [PageController::class, 'create']);
        Route::get('page/{page}', [PageController::class, 'show']);
        Route::post('page/{page}/update', [PageController::class, 'update']);
        // Notification
        Route::get('notification/unread/list', [NotificationController::class, 'unread']);
        Route::get('notification/all/list', [NotificationController::class, 'index']);
        Route::post('notification/all/read', [NotificationController::class, 'mark']);
        Route::post('notification/read', [NotificationController::class, 'individual']);
        Route::post('notification/unread', [NotificationController::class, 'markAsUnread']);
        Route::get('unread/notification/count', [NotificationController::class, 'unreadNotificationCount']);
        Route::get('unread/message/count', [NotificationController::class, 'unreadMessageCount']);
    });

});
//Payment Routes
Route::get('/checkout/success', [StripeController::class, 'success'])->name('checkout.success');
Route::get('/checkout/cancel', [StripeController::class, 'cancel'])->name('checkout.cancel');
Route::post('/location/update', [ApiUserController::class, 'updateLocation']);
Route::post('contact-us', [ApiFeedbackController::class, 'store']);
// Products
Route::get('/user/product/products/unathenticated', [ApiProductController::class, 'index']);
Route::get('/user/product/products/unathenticated/{id}', [ApiProductController::class, 'productsByCategory']);
Route::get('/user/product/{product}', [ApiProductController::class, 'show']);

//Categories
Route::get('user/category/all', [ApiCategoryController::class, 'all']);
//Cart
Route::post('user/cart/add', [CartController::class, 'store']);
Route::get('user/cart/items', [CartController::class, 'show']);
Route::delete('user/cart/remove/{cart}', [CartController::class, 'delete']);
Route::post('user/cart/change-quantity/{cart}', [CartController::class, 'update']);
Route::post('user/cart/change/quantity/byProductId', [CartController::class, 'updateByProductId']);
//Delivery Charges
Route::get('user/deliveryCharge/deliveryCharges', [ApiDeliveryChargeController::class, 'index']);
// Order
Route::post('user/order/add', [OrderController::class, 'store']);
//Questions
Route::get('user/question/categoryWise', [QuestionController::class, 'categoryWise']);
Route::get('user/question/preferences', [QuestionController::class, 'preferences']);
Route::get('user/question/optionsOfHeightCarrerFieldAndEducationlevel', [QuestionController::class, 'optionsOfHeightCarrerFieldAndEducationlevel']);
Route::get('user/nfcProfile/{id}', [AuthController::class, 'nfcProfileWithDetails']);
Route::get('user/profile/getTopProfiles', [PreferenceController::class, 'getTopProfiles']);
// Avatar
Route::get('user/avatars', [ApiAvatarController::class, 'index']);
Route::prefix('user')->group(function () {
    Route::post('/signup', [AuthController::class, 'signup']);
    Route::post('/login', action: [AuthController::class, 'login'])->name('login');
    Route::post('/biometric/login', [AuthController::class, 'loginBiomatric']);

    Route::middleware(['auth:sanctum', 'user'])->group(function () {
        //Logout
        Route::post('/logout', [AuthController::class, 'logout']);
        //User settings
        Route::get('/location/status', [ApiUserController::class, 'changeLocation']);
        Route::get('/location/live/status', [ApiUserController::class, 'changeLiveStatus']);
        Route::get('/lastActive/status', [ApiUserController::class, 'changeLastActiveStatus']);
        Route::post('/pinPoint/status', [ApiUserController::class, 'changePinPointStatus']);
        Route::post('/biometric/enable', [ApiUserController::class, 'addBiometricKey']);
        Route::get('/biometric/disable', [ApiUserController::class, 'disableBiometric']);
        Route::post('/update/nfc', [ApiUserController::class, 'updateNfc']);
        Route::post('/store/preferences', [PreferenceController::class, 'store']);

        // User Profile
        Route::get('profile', [AuthController::class, 'profile']);
        Route::get('profile/deleteAccount', [AuthController::class, 'deleteAccount']);
        Route::get('profile/tapProfile/{id}', [AuthController::class, 'tapProfile']);
        Route::get('profile/removeTapProfile/{id}', [AuthController::class, 'removeTapProfile']);
        Route::get('profile/getCountsOfChatFriendRequestAndTappedProfile', [AuthController::class, 'getCountsOfChatFriendRequestAndTappedProfile']);
        Route::get('profile/getTapProfiles', [AuthController::class, 'getTapProfiles']);
        Route::get('profile/getMatchedProfile', [PreferenceController::class, 'getProfiles']);
        Route::get('profile/getMatchedProfile/WithFilters', [PreferenceController::class, 'getProfilesWithFilters']);

        Route::post('/updateUserLocationAndRadius', [AuthController::class, 'updateUserLocationAndRadius']);
        Route::post('/uploadImages', [AuthController::class, 'uploadImages']);
        Route::post('/uploadSingleImage', [AuthController::class, 'uploadSingleImage']);
        Route::get('deleteImage/{image}', [AuthController::class, 'deleteImage']);

        Route::post('/uploadSocialLinks', [AuthController::class, 'uploadSocialLinks']);
        Route::get('profile/{user}', [AuthController::class, 'userProfile']);
        Route::get('profileWithDetails/{id}', [AuthController::class, 'profileWithDetails']);
        Route::post('profile/update', [AuthController::class, 'update']);
        Route::post('profile/updateAvatar', [AuthController::class, 'updateAvatar']);
        Route::post('change-password', [AuthController::class, 'updatePassword']);
        // Page
        Route::get('page/{page}', [PageController::class, 'showBySlug']);
        // Products
        // Route::get('product/products', [ApiProductController::class, 'index']);
        Route::get('product/products', [ApiProductController::class, 'index']);
        Route::get('product/products/{id}', [ApiProductController::class, 'productsByCategory']);
        // Route::get('product/{product}', [ApiProductController::class, 'show']);
        // Sizes Module


        // Delivery Charges
        // Route::get('deliveryCharge/deliveryCharges', [ApiDeliveryChargeController::class, 'index']);

        // Reports
        Route::post('report/create', [ReportController::class, 'store']);
        // Cart
        // Route::post('cart/add', [CartController::class, 'store']);
        // Route::get('cart/items', [CartController::class, 'show']);
        // Route::delete('cart/remove/{cart}', [CartController::class, 'delete']);
        // Route::post('cart/change-quantity/{cart}', [CartController::class, 'update']);
        // Route::post('cart/change/quantity/byProductId', [CartController::class, 'updateByProductId']);
        // WishList
        Route::post('wishlist/add', [WishListController::class, 'store']);
        Route::get('wishlist/items', [WishListController::class, 'show']);
        Route::delete('wishlist/remove/{wishlist}', [WishListController::class, 'delete']);

        // Recently Viewed Products
        Route::post('recentlyViewedProduct/add', [RecentlyViewedProductController::class, 'store']);
        Route::get('recentlyViewedProduct/recentlyViewedProducts', [RecentlyViewedProductController::class, 'index']);
        // //Questions

        // Route::get('category/all', [ApiCategoryController::class, 'all']);

        // // Order
        // Route::post('order/add', [OrderController::class, 'store']);
        Route::get('order/orders', [OrderController::class, 'index']);
        Route::get('order/{order}', action: [OrderController::class, 'show']);
        Route::post('order/storeOrder/changeStatus/{store}', [OrderController::class, 'changeStoreStatus']);
        //Banners
        Route::get('banner/banners', [\App\Http\Controllers\Api\BannerController::class, 'index']);
        //Events
        Route::get('event/events', [\App\Http\Controllers\Api\EventController::class, 'index']);

        // Order
        Route::post('ratings/add', [RatingController::class, 'store']);
        //Friends
        Route::post('friends/send/{receiverId}', [FriendController::class, 'sendRequest']);
        Route::post('friends/cancel/user/{receiverId}', [FriendController::class, 'AddToCancelledUsers']);
        Route::post('friends/accept/{requestId}', [FriendController::class, 'acceptRequest']);
        Route::post('friends/reject/{requestId}', [FriendController::class, 'rejectRequest']);
        Route::post('friends/cancel/{user_id}', [FriendController::class, 'cancelRequest']);
        Route::get('friends/requests', [FriendController::class, 'friendRequests']);
        Route::get('friends/requestsCount', [FriendController::class, 'friendRequestsCount']);
        Route::get('friends', [FriendController::class, 'getFriendsList']);
        Route::get('friends/getDailyFriendRequestCount', [FriendController::class, 'getDailyFriendRequestCount']);
        Route::get('friends/unFriend/{id}', [FriendController::class, 'unFriend']);
        // Chat Routes
        Route::get('chat/getUnread-chats', [ChatController::class, 'get_unread_chats']);
        Route::get('chat/getChatList', [ChatController::class, 'get_chat_list']);
        Route::get('chat/getChat/{id}', [ChatController::class, 'get_chat']);
        Route::post('chat/sendMessage', [ChatController::class, 'send_message']);
        Route::post('chat/create', [ChatController::class, 'createChat']);
        Route::post('chat/createGroup', [ChatController::class, 'createGroup']);
        Route::get('chat/leaveGroup/{id}', [ChatController::class, 'leaveGroup']);
        //Notification
        Route::get('notification/unread/list', [NotificationController::class, 'unread']);
        Route::get('notification/all/list', [NotificationController::class, 'index']);
        Route::post('notification/all/read', [NotificationController::class, 'mark']);
        Route::post('notification/read', [NotificationController::class, 'individual']);
        Route::post('notification/unread', [NotificationController::class, 'markAsUnread']);
        Route::get('unread/notification/count', [NotificationController::class, 'unreadNotificationCount']);
        Route::get('unread/message/count', [NotificationController::class, 'unreadMessageCount']);
        Route::get('unread/message/count', [NotificationController::class, 'unreadMessageCount']);
    });

    // send firebase notification
    Route::post('notification/firebase/send', [NotificationController::class, 'sendFirebaseNotification']);
});

