import React, { useState, useEffect } from 'react';
import { Placeholder } from 'react-bootstrap';

var TableLoading = function TableLoading(_ref) {
  var columns = _ref.columns,
      lines = _ref.lines,
      _ref$tbody = _ref.tbody,
      tbody = _ref$tbody === void 0 ? true : _ref$tbody,
      _ref$tbodyProps = _ref.tbodyProps,
      tbodyProps = _ref$tbodyProps === void 0 ? {} : _ref$tbodyProps;

  var _useState = useState([]),
      trs = _useState[0],
      setTrs = _useState[1];

  useEffect(function () {
    var trs = [];

    var _loop = function _loop(x) {
      var tds = [];
      (Array.isArray(columns) ? columns : Array.from({
        length: columns
      }, function () {
        return {
          min: 4,
          max: 12
        };
      })).map(function (_ref2) {
        var min = _ref2.min,
            max = _ref2.max;
        tds.push(Math.floor(Math.random() * (max - min)) + min);
      });
      trs.push(tds);
    };

    for (var x = 0; x < lines; x++) {
      _loop();
    }

    setTrs(trs);
  }, [columns, lines]);

  var bodyRender = function bodyRender(component) {
    return tbody ? React.createElement("tbody", Object.assign({}, tbodyProps), component) : React.createElement(React.Fragment, null, component);
  };

  return bodyRender(trs.map(function (tds, trIndex) {
    return React.createElement("tr", {
      key: trIndex + 1
    }, tds.map(function (td, tdIndex) {
      return React.createElement("td", {
        style: {
          cursor: "wait"
        },
        key: tdIndex
      }, React.createElement(Placeholder, {
        as: "div",
        animation: "glow"
      }, React.createElement(Placeholder, {
        xs: td
      })));
    }));
  }));
};

export { TableLoading };
//# sourceMappingURL=react-bootstrap-table-loading.esm.js.map
