"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var React = _interopRequireWildcard(require("react"));
var _FormCheck = _interopRequireDefault(require("./FormCheck"));
var _FormControl = _interopRequireDefault(require("./FormControl"));
var _FormFloating = _interopRequireDefault(require("./FormFloating"));
var _FormGroup = _interopRequireDefault(require("./FormGroup"));
var _FormLabel = _interopRequireDefault(require("./FormLabel"));
var _FormRange = _interopRequireDefault(require("./FormRange"));
var _FormSelect = _interopRequireDefault(require("./FormSelect"));
var _FormText = _interopRequireDefault(require("./FormText"));
var _Switch = _interopRequireDefault(require("./Switch"));
var _FloatingLabel = _interopRequireDefault(require("./FloatingLabel"));
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const propTypes = {
  /**
   * The Form `ref` will be forwarded to the underlying element,
   * which means, unless it's rendered `as` a composite component,
   * it will be a DOM node, when resolved.
   *
   * @type {ReactRef}
   * @alias ref
   */
  _ref: _propTypes.default.any,
  /**
   * Mark a form as having been validated. Setting it to `true` will
   * toggle any validation styles on the forms elements.
   */
  validated: _propTypes.default.bool,
  as: _propTypes.default.elementType
};
const Form = /*#__PURE__*/React.forwardRef(({
  className,
  validated,
  // Need to define the default "as" during prop destructuring to be compatible with styled-components github.com/react-bootstrap/react-bootstrap/issues/3595
  as: Component = 'form',
  ...props
}, ref) => /*#__PURE__*/(0, _jsxRuntime.jsx)(Component, {
  ...props,
  ref: ref,
  className: (0, _classnames.default)(className, validated && 'was-validated')
}));
Form.displayName = 'Form';
Form.propTypes = propTypes;
var _default = Object.assign(Form, {
  Group: _FormGroup.default,
  Control: _FormControl.default,
  Floating: _FormFloating.default,
  Check: _FormCheck.default,
  Switch: _Switch.default,
  Label: _FormLabel.default,
  Text: _FormText.default,
  Range: _FormRange.default,
  Select: _FormSelect.default,
  FloatingLabel: _FloatingLabel.default
});
exports.default = _default;
module.exports = exports.default;