"use strict";

var _Object$defineProperty = require("@babel/runtime-corejs3/core-js-stable/object/define-property");

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");

_Object$defineProperty(exports, "__esModule", {
  value: true
});

exports["default"] = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _AutoHideFollowButton = _interopRequireDefault(require("./ScrollToBottom/AutoHideFollowButton"));

var _Composer = _interopRequireDefault(require("./ScrollToBottom/Composer"));

var _Panel = _interopRequireDefault(require("./ScrollToBottom/Panel"));

var _useStyleToClassName = _interopRequireDefault(require("./hooks/internal/useStyleToClassName"));

var ROOT_STYLE = {
  position: 'relative'
};

var BasicScrollToBottomCore = function BasicScrollToBottomCore(_ref) {
  var children = _ref.children,
      className = _ref.className,
      followButtonClassName = _ref.followButtonClassName,
      scrollViewClassName = _ref.scrollViewClassName;
  var rootCSS = (0, _useStyleToClassName["default"])()(ROOT_STYLE);
  return /*#__PURE__*/_react["default"].createElement("div", {
    className: (0, _classnames["default"])(rootCSS, (className || '') + '')
  }, /*#__PURE__*/_react["default"].createElement(_Panel["default"], {
    className: (scrollViewClassName || '') + ''
  }, children), /*#__PURE__*/_react["default"].createElement(_AutoHideFollowButton["default"], {
    className: (followButtonClassName || '') + ''
  }));
};

BasicScrollToBottomCore.defaultProps = {
  children: undefined,
  className: undefined,
  followButtonClassName: undefined,
  scrollViewClassName: undefined
};
BasicScrollToBottomCore.propTypes = {
  children: _propTypes["default"].any,
  className: _propTypes["default"].string,
  followButtonClassName: _propTypes["default"].string,
  scrollViewClassName: _propTypes["default"].string
};

var BasicScrollToBottom = function BasicScrollToBottom(_ref2) {
  var checkInterval = _ref2.checkInterval,
      children = _ref2.children,
      className = _ref2.className,
      debounce = _ref2.debounce,
      debug = _ref2.debug,
      followButtonClassName = _ref2.followButtonClassName,
      initialScrollBehavior = _ref2.initialScrollBehavior,
      mode = _ref2.mode,
      nonce = _ref2.nonce,
      scroller = _ref2.scroller,
      scrollViewClassName = _ref2.scrollViewClassName;
  return /*#__PURE__*/_react["default"].createElement(_Composer["default"], {
    checkInterval: checkInterval,
    debounce: debounce,
    debug: debug,
    initialScrollBehavior: initialScrollBehavior,
    mode: mode,
    nonce: nonce,
    scroller: scroller
  }, /*#__PURE__*/_react["default"].createElement(BasicScrollToBottomCore, {
    className: className,
    followButtonClassName: followButtonClassName,
    scrollViewClassName: scrollViewClassName
  }, children));
};

BasicScrollToBottom.defaultProps = {
  checkInterval: undefined,
  children: undefined,
  className: undefined,
  debounce: undefined,
  debug: undefined,
  followButtonClassName: undefined,
  initialScrollBehavior: 'smooth',
  mode: undefined,
  nonce: undefined,
  scroller: undefined,
  scrollViewClassName: undefined
};
BasicScrollToBottom.propTypes = {
  checkInterval: _propTypes["default"].number,
  children: _propTypes["default"].any,
  className: _propTypes["default"].string,
  debounce: _propTypes["default"].number,
  debug: _propTypes["default"].bool,
  followButtonClassName: _propTypes["default"].string,
  initialScrollBehavior: _propTypes["default"].oneOf(['auto', 'smooth']),
  mode: _propTypes["default"].oneOf(['bottom', 'top']),
  nonce: _propTypes["default"].string,
  scroller: _propTypes["default"].func,
  scrollViewClassName: _propTypes["default"].string
};
var _default = BasicScrollToBottom;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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