"use strict";

var _Object$defineProperty = require("@babel/runtime-corejs3/core-js-stable/object/define-property");

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");

_Object$defineProperty(exports, "__esModule", {
  value: true
});

exports["default"] = void 0;

var _now = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/date/now"));

require("core-js/modules/es.function.name.js");

var _react = require("react");

var _debounce = _interopRequireDefault(require("./debounce"));

var EventSpy = function EventSpy(_ref) {
  var debounce = _ref.debounce,
      name = _ref.name,
      onEvent = _ref.onEvent,
      target = _ref.target;
  // We need to save the "onEvent" to ref.
  // This is because "onEvent" may change from time to time, but debounce may still fire to the older callback.
  var onEventRef = (0, _react.useRef)();
  onEventRef.current = onEvent;
  var debouncer = (0, _react.useMemo)(function () {
    return (0, _debounce["default"])(function (event) {
      var current = onEventRef.current;
      current && current(event);
    }, debounce);
  }, [debounce, onEventRef]);
  var handleEvent = (0, _react.useCallback)(function (event) {
    event.timeStampLow = (0, _now["default"])();
    debouncer(event);
  }, [debouncer]);
  (0, _react.useLayoutEffect)(function () {
    target.addEventListener(name, handleEvent, {
      passive: true
    });
    handleEvent({
      target: target,
      type: name
    });
    return function () {
      return target.removeEventListener(name, handleEvent);
    };
  }, [name, handleEvent, target]);
  return false;
};

EventSpy.defaultProps = {
  debounce: 200
};
var _default = EventSpy;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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