"use strict";

var _Object$defineProperty = require("@babel/runtime-corejs3/core-js-stable/object/define-property");

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");

_Object$defineProperty(exports, "__esModule", {
  value: true
});

exports["default"] = void 0;

require("core-js/modules/es.function.name.js");

var _sign = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/math/sign"));

var _now = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/date/now"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = require("react");

/* eslint no-magic-numbers: ["error", { "ignore": [0, 1, 1.5, 5] }] */
function squareStepper(current, to) {
  var sign = (0, _sign["default"])(to - current);
  var step = Math.sqrt(Math.abs(to - current));
  var next = current + step * sign;

  if (sign > 0) {
    return Math.min(to, next);
  }

  return Math.max(to, next);
}

function step(from, to, stepper, index) {
  var next = from;

  for (var i = 0; i < index; i++) {
    next = stepper(next, to);
  }

  return next;
}

var SpineTo = function SpineTo(_ref) {
  var name = _ref.name,
      onEnd = _ref.onEnd,
      target = _ref.target,
      value = _ref.value;
  var animator = (0, _react.useRef)();
  var animate = (0, _react.useCallback)(function (name, from, to, index) {
    var start = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : (0, _now["default"])();

    if (to === '100%' || typeof to === 'number') {
      cancelAnimationFrame(animator.current);
      animator.current = requestAnimationFrame(function () {
        if (target) {
          var toNumber = to === '100%' ? target.scrollHeight - target.offsetHeight : to;
          var nextValue = step(from, toNumber, squareStepper, ((0, _now["default"])() - start) / 5);

          if (Math.abs(toNumber - nextValue) < 1.5) {
            nextValue = toNumber;
          }

          target[name] = nextValue;

          if (toNumber === nextValue) {
            onEnd && onEnd(true);
          } else {
            animate(name, from, to, index + 1, start);
          }
        }
      });
    }
  }, [animator, onEnd, target]);
  var handleCancelAnimation = (0, _react.useCallback)(function () {
    cancelAnimationFrame(animator.current);
    onEnd && onEnd(false);
  }, [onEnd]);
  (0, _react.useLayoutEffect)(function () {
    animate(name, target[name], value, 1);

    if (target) {
      target.addEventListener('pointerdown', handleCancelAnimation, {
        passive: true
      });
      target.addEventListener('wheel', handleCancelAnimation, {
        passive: true
      });
      return function () {
        target.removeEventListener('pointerdown', handleCancelAnimation);
        target.removeEventListener('wheel', handleCancelAnimation);
        cancelAnimationFrame(animator.current);
      };
    }

    return function () {
      return cancelAnimationFrame(animator.current);
    };
  }, [animate, animator, handleCancelAnimation, name, target, value]);
  return false;
};

SpineTo.propTypes = {
  name: _propTypes["default"].string.isRequired,
  onEnd: _propTypes["default"].func,
  target: _propTypes["default"].any.isRequired,
  value: _propTypes["default"].oneOfType([_propTypes["default"].number, _propTypes["default"].oneOf(['100%'])]).isRequired
};
var _default = SpineTo;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9TcGluZVRvLmpzIl0sIm5hbWVzIjpbInNxdWFyZVN0ZXBwZXIiLCJjdXJyZW50IiwidG8iLCJzaWduIiwic3RlcCIsIk1hdGgiLCJzcXJ0IiwiYWJzIiwibmV4dCIsIm1pbiIsIm1heCIsImZyb20iLCJzdGVwcGVyIiwiaW5kZXgiLCJpIiwiU3BpbmVUbyIsIm5hbWUiLCJvbkVuZCIsInRhcmdldCIsInZhbHVlIiwiYW5pbWF0b3IiLCJhbmltYXRlIiwic3RhcnQiLCJjYW5jZWxBbmltYXRpb25GcmFtZSIsInJlcXVlc3RBbmltYXRpb25GcmFtZSIsInRvTnVtYmVyIiwic2Nyb2xsSGVpZ2h0Iiwib2Zmc2V0SGVpZ2h0IiwibmV4dFZhbHVlIiwiaGFuZGxlQ2FuY2VsQW5pbWF0aW9uIiwiYWRkRXZlbnRMaXN0ZW5lciIsInBhc3NpdmUiLCJyZW1vdmVFdmVudExpc3RlbmVyIiwicHJvcFR5cGVzIiwiUHJvcFR5cGVzIiwic3RyaW5nIiwiaXNSZXF1aXJlZCIsImZ1bmMiLCJhbnkiLCJvbmVPZlR5cGUiLCJudW1iZXIiLCJvbmVPZiJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBRUE7O0FBQ0E7O0FBSEE7QUFLQSxTQUFTQSxhQUFULENBQXVCQyxPQUF2QixFQUFnQ0MsRUFBaEMsRUFBb0M7QUFDbEMsTUFBTUMsSUFBSSxHQUFHLHNCQUFVRCxFQUFFLEdBQUdELE9BQWYsQ0FBYjtBQUNBLE1BQU1HLElBQUksR0FBR0MsSUFBSSxDQUFDQyxJQUFMLENBQVVELElBQUksQ0FBQ0UsR0FBTCxDQUFTTCxFQUFFLEdBQUdELE9BQWQsQ0FBVixDQUFiO0FBQ0EsTUFBTU8sSUFBSSxHQUFHUCxPQUFPLEdBQUdHLElBQUksR0FBR0QsSUFBOUI7O0FBRUEsTUFBSUEsSUFBSSxHQUFHLENBQVgsRUFBYztBQUNaLFdBQU9FLElBQUksQ0FBQ0ksR0FBTCxDQUFTUCxFQUFULEVBQWFNLElBQWIsQ0FBUDtBQUNEOztBQUVELFNBQU9ILElBQUksQ0FBQ0ssR0FBTCxDQUFTUixFQUFULEVBQWFNLElBQWIsQ0FBUDtBQUNEOztBQUVELFNBQVNKLElBQVQsQ0FBY08sSUFBZCxFQUFvQlQsRUFBcEIsRUFBd0JVLE9BQXhCLEVBQWlDQyxLQUFqQyxFQUF3QztBQUN0QyxNQUFJTCxJQUFJLEdBQUdHLElBQVg7O0FBRUEsT0FBSyxJQUFJRyxDQUFDLEdBQUcsQ0FBYixFQUFnQkEsQ0FBQyxHQUFHRCxLQUFwQixFQUEyQkMsQ0FBQyxFQUE1QixFQUFnQztBQUM5Qk4sSUFBQUEsSUFBSSxHQUFHSSxPQUFPLENBQUNKLElBQUQsRUFBT04sRUFBUCxDQUFkO0FBQ0Q7O0FBRUQsU0FBT00sSUFBUDtBQUNEOztBQUVELElBQU1PLE9BQU8sR0FBRyxTQUFWQSxPQUFVLE9BQW9DO0FBQUEsTUFBakNDLElBQWlDLFFBQWpDQSxJQUFpQztBQUFBLE1BQTNCQyxLQUEyQixRQUEzQkEsS0FBMkI7QUFBQSxNQUFwQkMsTUFBb0IsUUFBcEJBLE1BQW9CO0FBQUEsTUFBWkMsS0FBWSxRQUFaQSxLQUFZO0FBQ2xELE1BQU1DLFFBQVEsR0FBRyxvQkFBakI7QUFFQSxNQUFNQyxPQUFPLEdBQUcsd0JBQ2QsVUFBQ0wsSUFBRCxFQUFPTCxJQUFQLEVBQWFULEVBQWIsRUFBaUJXLEtBQWpCLEVBQStDO0FBQUEsUUFBdkJTLEtBQXVCLHVFQUFmLHNCQUFlOztBQUM3QyxRQUFJcEIsRUFBRSxLQUFLLE1BQVAsSUFBaUIsT0FBT0EsRUFBUCxLQUFjLFFBQW5DLEVBQTZDO0FBQzNDcUIsTUFBQUEsb0JBQW9CLENBQUNILFFBQVEsQ0FBQ25CLE9BQVYsQ0FBcEI7QUFFQW1CLE1BQUFBLFFBQVEsQ0FBQ25CLE9BQVQsR0FBbUJ1QixxQkFBcUIsQ0FBQyxZQUFNO0FBQzdDLFlBQUlOLE1BQUosRUFBWTtBQUNWLGNBQU1PLFFBQVEsR0FBR3ZCLEVBQUUsS0FBSyxNQUFQLEdBQWdCZ0IsTUFBTSxDQUFDUSxZQUFQLEdBQXNCUixNQUFNLENBQUNTLFlBQTdDLEdBQTREekIsRUFBN0U7QUFDQSxjQUFJMEIsU0FBUyxHQUFHeEIsSUFBSSxDQUFDTyxJQUFELEVBQU9jLFFBQVAsRUFBaUJ6QixhQUFqQixFQUFnQyxDQUFDLHlCQUFhc0IsS0FBZCxJQUF1QixDQUF2RCxDQUFwQjs7QUFFQSxjQUFJakIsSUFBSSxDQUFDRSxHQUFMLENBQVNrQixRQUFRLEdBQUdHLFNBQXBCLElBQWlDLEdBQXJDLEVBQTBDO0FBQ3hDQSxZQUFBQSxTQUFTLEdBQUdILFFBQVo7QUFDRDs7QUFFRFAsVUFBQUEsTUFBTSxDQUFDRixJQUFELENBQU4sR0FBZVksU0FBZjs7QUFFQSxjQUFJSCxRQUFRLEtBQUtHLFNBQWpCLEVBQTRCO0FBQzFCWCxZQUFBQSxLQUFLLElBQUlBLEtBQUssQ0FBQyxJQUFELENBQWQ7QUFDRCxXQUZELE1BRU87QUFDTEksWUFBQUEsT0FBTyxDQUFDTCxJQUFELEVBQU9MLElBQVAsRUFBYVQsRUFBYixFQUFpQlcsS0FBSyxHQUFHLENBQXpCLEVBQTRCUyxLQUE1QixDQUFQO0FBQ0Q7QUFDRjtBQUNGLE9BakJ1QyxDQUF4QztBQWtCRDtBQUNGLEdBeEJhLEVBeUJkLENBQUNGLFFBQUQsRUFBV0gsS0FBWCxFQUFrQkMsTUFBbEIsQ0F6QmMsQ0FBaEI7QUE0QkEsTUFBTVcscUJBQXFCLEdBQUcsd0JBQVksWUFBTTtBQUM5Q04sSUFBQUEsb0JBQW9CLENBQUNILFFBQVEsQ0FBQ25CLE9BQVYsQ0FBcEI7QUFDQWdCLElBQUFBLEtBQUssSUFBSUEsS0FBSyxDQUFDLEtBQUQsQ0FBZDtBQUNELEdBSDZCLEVBRzNCLENBQUNBLEtBQUQsQ0FIMkIsQ0FBOUI7QUFLQSw4QkFBZ0IsWUFBTTtBQUNwQkksSUFBQUEsT0FBTyxDQUFDTCxJQUFELEVBQU9FLE1BQU0sQ0FBQ0YsSUFBRCxDQUFiLEVBQXFCRyxLQUFyQixFQUE0QixDQUE1QixDQUFQOztBQUVBLFFBQUlELE1BQUosRUFBWTtBQUNWQSxNQUFBQSxNQUFNLENBQUNZLGdCQUFQLENBQXdCLGFBQXhCLEVBQXVDRCxxQkFBdkMsRUFBOEQ7QUFBRUUsUUFBQUEsT0FBTyxFQUFFO0FBQVgsT0FBOUQ7QUFDQWIsTUFBQUEsTUFBTSxDQUFDWSxnQkFBUCxDQUF3QixPQUF4QixFQUFpQ0QscUJBQWpDLEVBQXdEO0FBQUVFLFFBQUFBLE9BQU8sRUFBRTtBQUFYLE9BQXhEO0FBRUEsYUFBTyxZQUFNO0FBQ1hiLFFBQUFBLE1BQU0sQ0FBQ2MsbUJBQVAsQ0FBMkIsYUFBM0IsRUFBMENILHFCQUExQztBQUNBWCxRQUFBQSxNQUFNLENBQUNjLG1CQUFQLENBQTJCLE9BQTNCLEVBQW9DSCxxQkFBcEM7QUFDQU4sUUFBQUEsb0JBQW9CLENBQUNILFFBQVEsQ0FBQ25CLE9BQVYsQ0FBcEI7QUFDRCxPQUpEO0FBS0Q7O0FBRUQsV0FBTztBQUFBLGFBQU1zQixvQkFBb0IsQ0FBQ0gsUUFBUSxDQUFDbkIsT0FBVixDQUExQjtBQUFBLEtBQVA7QUFDRCxHQWZELEVBZUcsQ0FBQ29CLE9BQUQsRUFBVUQsUUFBVixFQUFvQlMscUJBQXBCLEVBQTJDYixJQUEzQyxFQUFpREUsTUFBakQsRUFBeURDLEtBQXpELENBZkg7QUFpQkEsU0FBTyxLQUFQO0FBQ0QsQ0F0REQ7O0FBd0RBSixPQUFPLENBQUNrQixTQUFSLEdBQW9CO0FBQ2xCakIsRUFBQUEsSUFBSSxFQUFFa0Isc0JBQVVDLE1BQVYsQ0FBaUJDLFVBREw7QUFFbEJuQixFQUFBQSxLQUFLLEVBQUVpQixzQkFBVUcsSUFGQztBQUdsQm5CLEVBQUFBLE1BQU0sRUFBRWdCLHNCQUFVSSxHQUFWLENBQWNGLFVBSEo7QUFJbEJqQixFQUFBQSxLQUFLLEVBQUVlLHNCQUFVSyxTQUFWLENBQW9CLENBQUNMLHNCQUFVTSxNQUFYLEVBQW1CTixzQkFBVU8sS0FBVixDQUFnQixDQUFDLE1BQUQsQ0FBaEIsQ0FBbkIsQ0FBcEIsRUFBbUVMO0FBSnhELENBQXBCO2VBT2VyQixPIiwic291cmNlc0NvbnRlbnQiOlsiLyogZXNsaW50IG5vLW1hZ2ljLW51bWJlcnM6IFtcImVycm9yXCIsIHsgXCJpZ25vcmVcIjogWzAsIDEsIDEuNSwgNV0gfV0gKi9cblxuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCB7IHVzZUNhbGxiYWNrLCB1c2VMYXlvdXRFZmZlY3QsIHVzZVJlZiB9IGZyb20gJ3JlYWN0JztcblxuZnVuY3Rpb24gc3F1YXJlU3RlcHBlcihjdXJyZW50LCB0bykge1xuICBjb25zdCBzaWduID0gTWF0aC5zaWduKHRvIC0gY3VycmVudCk7XG4gIGNvbnN0IHN0ZXAgPSBNYXRoLnNxcnQoTWF0aC5hYnModG8gLSBjdXJyZW50KSk7XG4gIGNvbnN0IG5leHQgPSBjdXJyZW50ICsgc3RlcCAqIHNpZ247XG5cbiAgaWYgKHNpZ24gPiAwKSB7XG4gICAgcmV0dXJuIE1hdGgubWluKHRvLCBuZXh0KTtcbiAgfVxuXG4gIHJldHVybiBNYXRoLm1heCh0bywgbmV4dCk7XG59XG5cbmZ1bmN0aW9uIHN0ZXAoZnJvbSwgdG8sIHN0ZXBwZXIsIGluZGV4KSB7XG4gIGxldCBuZXh0ID0gZnJvbTtcblxuICBmb3IgKGxldCBpID0gMDsgaSA8IGluZGV4OyBpKyspIHtcbiAgICBuZXh0ID0gc3RlcHBlcihuZXh0LCB0byk7XG4gIH1cblxuICByZXR1cm4gbmV4dDtcbn1cblxuY29uc3QgU3BpbmVUbyA9ICh7IG5hbWUsIG9uRW5kLCB0YXJnZXQsIHZhbHVlIH0pID0+IHtcbiAgY29uc3QgYW5pbWF0b3IgPSB1c2VSZWYoKTtcblxuICBjb25zdCBhbmltYXRlID0gdXNlQ2FsbGJhY2soXG4gICAgKG5hbWUsIGZyb20sIHRvLCBpbmRleCwgc3RhcnQgPSBEYXRlLm5vdygpKSA9PiB7XG4gICAgICBpZiAodG8gPT09ICcxMDAlJyB8fCB0eXBlb2YgdG8gPT09ICdudW1iZXInKSB7XG4gICAgICAgIGNhbmNlbEFuaW1hdGlvbkZyYW1lKGFuaW1hdG9yLmN1cnJlbnQpO1xuXG4gICAgICAgIGFuaW1hdG9yLmN1cnJlbnQgPSByZXF1ZXN0QW5pbWF0aW9uRnJhbWUoKCkgPT4ge1xuICAgICAgICAgIGlmICh0YXJnZXQpIHtcbiAgICAgICAgICAgIGNvbnN0IHRvTnVtYmVyID0gdG8gPT09ICcxMDAlJyA/IHRhcmdldC5zY3JvbGxIZWlnaHQgLSB0YXJnZXQub2Zmc2V0SGVpZ2h0IDogdG87XG4gICAgICAgICAgICBsZXQgbmV4dFZhbHVlID0gc3RlcChmcm9tLCB0b051bWJlciwgc3F1YXJlU3RlcHBlciwgKERhdGUubm93KCkgLSBzdGFydCkgLyA1KTtcblxuICAgICAgICAgICAgaWYgKE1hdGguYWJzKHRvTnVtYmVyIC0gbmV4dFZhbHVlKSA8IDEuNSkge1xuICAgICAgICAgICAgICBuZXh0VmFsdWUgPSB0b051bWJlcjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgdGFyZ2V0W25hbWVdID0gbmV4dFZhbHVlO1xuXG4gICAgICAgICAgICBpZiAodG9OdW1iZXIgPT09IG5leHRWYWx1ZSkge1xuICAgICAgICAgICAgICBvbkVuZCAmJiBvbkVuZCh0cnVlKTtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgIGFuaW1hdGUobmFtZSwgZnJvbSwgdG8sIGluZGV4ICsgMSwgc3RhcnQpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfSxcbiAgICBbYW5pbWF0b3IsIG9uRW5kLCB0YXJnZXRdXG4gICk7XG5cbiAgY29uc3QgaGFuZGxlQ2FuY2VsQW5pbWF0aW9uID0gdXNlQ2FsbGJhY2soKCkgPT4ge1xuICAgIGNhbmNlbEFuaW1hdGlvbkZyYW1lKGFuaW1hdG9yLmN1cnJlbnQpO1xuICAgIG9uRW5kICYmIG9uRW5kKGZhbHNlKTtcbiAgfSwgW29uRW5kXSk7XG5cbiAgdXNlTGF5b3V0RWZmZWN0KCgpID0+IHtcbiAgICBhbmltYXRlKG5hbWUsIHRhcmdldFtuYW1lXSwgdmFsdWUsIDEpO1xuXG4gICAgaWYgKHRhcmdldCkge1xuICAgICAgdGFyZ2V0LmFkZEV2ZW50TGlzdGVuZXIoJ3BvaW50ZXJkb3duJywgaGFuZGxlQ2FuY2VsQW5pbWF0aW9uLCB7IHBhc3NpdmU6IHRydWUgfSk7XG4gICAgICB0YXJnZXQuYWRkRXZlbnRMaXN0ZW5lcignd2hlZWwnLCBoYW5kbGVDYW5jZWxBbmltYXRpb24sIHsgcGFzc2l2ZTogdHJ1ZSB9KTtcblxuICAgICAgcmV0dXJuICgpID0+IHtcbiAgICAgICAgdGFyZ2V0LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ3BvaW50ZXJkb3duJywgaGFuZGxlQ2FuY2VsQW5pbWF0aW9uKTtcbiAgICAgICAgdGFyZ2V0LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ3doZWVsJywgaGFuZGxlQ2FuY2VsQW5pbWF0aW9uKTtcbiAgICAgICAgY2FuY2VsQW5pbWF0aW9uRnJhbWUoYW5pbWF0b3IuY3VycmVudCk7XG4gICAgICB9O1xuICAgIH1cblxuICAgIHJldHVybiAoKSA9PiBjYW5jZWxBbmltYXRpb25GcmFtZShhbmltYXRvci5jdXJyZW50KTtcbiAgfSwgW2FuaW1hdGUsIGFuaW1hdG9yLCBoYW5kbGVDYW5jZWxBbmltYXRpb24sIG5hbWUsIHRhcmdldCwgdmFsdWVdKTtcblxuICByZXR1cm4gZmFsc2U7XG59O1xuXG5TcGluZVRvLnByb3BUeXBlcyA9IHtcbiAgbmFtZTogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICBvbkVuZDogUHJvcFR5cGVzLmZ1bmMsXG4gIHRhcmdldDogUHJvcFR5cGVzLmFueS5pc1JlcXVpcmVkLFxuICB2YWx1ZTogUHJvcFR5cGVzLm9uZU9mVHlwZShbUHJvcFR5cGVzLm51bWJlciwgUHJvcFR5cGVzLm9uZU9mKFsnMTAwJSddKV0pLmlzUmVxdWlyZWRcbn07XG5cbmV4cG9ydCBkZWZhdWx0IFNwaW5lVG87XG4iXX0=