"use strict";

var _Object$defineProperty = require("@babel/runtime-corejs3/core-js-stable/object/define-property");

_Object$defineProperty(exports, "__esModule", {
  value: true
});

exports["default"] = addVersionToMetaTag;

/* global global:readonly, process:readonly */

/* eslint no-empty: ["error", { "allowEmptyCatch": true }] */
function setMetaTag(name, content) {
  try {
    var _global = global,
        document = _global.document;

    if (typeof document !== 'undefined' && document.createElement && document.head && document.head.appendChild) {
      var meta = document.querySelector("html meta[name=\"".concat(encodeURI(name), "\"]")) || document.createElement('meta');
      meta.setAttribute('name', name);
      meta.setAttribute('content', content);
      document.head.appendChild(meta);
    }
  } catch (err) {}
}

function addVersionToMetaTag() {
  setMetaTag('react-scroll-to-bottom:version', "4.2.0");
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9hZGRWZXJzaW9uVG9NZXRhVGFnLmpzIl0sIm5hbWVzIjpbInNldE1ldGFUYWciLCJuYW1lIiwiY29udGVudCIsImdsb2JhbCIsImRvY3VtZW50IiwiY3JlYXRlRWxlbWVudCIsImhlYWQiLCJhcHBlbmRDaGlsZCIsIm1ldGEiLCJxdWVyeVNlbGVjdG9yIiwiZW5jb2RlVVJJIiwic2V0QXR0cmlidXRlIiwiZXJyIiwiYWRkVmVyc2lvblRvTWV0YVRhZyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUFBOztBQUNBO0FBRUEsU0FBU0EsVUFBVCxDQUFvQkMsSUFBcEIsRUFBMEJDLE9BQTFCLEVBQW1DO0FBQ2pDLE1BQUk7QUFDRixrQkFBcUJDLE1BQXJCO0FBQUEsUUFBUUMsUUFBUixXQUFRQSxRQUFSOztBQUVBLFFBQUksT0FBT0EsUUFBUCxLQUFvQixXQUFwQixJQUFtQ0EsUUFBUSxDQUFDQyxhQUE1QyxJQUE2REQsUUFBUSxDQUFDRSxJQUF0RSxJQUE4RUYsUUFBUSxDQUFDRSxJQUFULENBQWNDLFdBQWhHLEVBQTZHO0FBQzNHLFVBQU1DLElBQUksR0FBR0osUUFBUSxDQUFDSyxhQUFULDRCQUEwQ0MsU0FBUyxDQUFDVCxJQUFELENBQW5ELGFBQWtFRyxRQUFRLENBQUNDLGFBQVQsQ0FBdUIsTUFBdkIsQ0FBL0U7QUFFQUcsTUFBQUEsSUFBSSxDQUFDRyxZQUFMLENBQWtCLE1BQWxCLEVBQTBCVixJQUExQjtBQUNBTyxNQUFBQSxJQUFJLENBQUNHLFlBQUwsQ0FBa0IsU0FBbEIsRUFBNkJULE9BQTdCO0FBRUFFLE1BQUFBLFFBQVEsQ0FBQ0UsSUFBVCxDQUFjQyxXQUFkLENBQTBCQyxJQUExQjtBQUNEO0FBQ0YsR0FYRCxDQVdFLE9BQU9JLEdBQVAsRUFBWSxDQUFFO0FBQ2pCOztBQUVjLFNBQVNDLG1CQUFULEdBQStCO0FBQzVDYixFQUFBQSxVQUFVLENBQUMsZ0NBQUQsVUFBVjtBQUNEIiwic291cmNlc0NvbnRlbnQiOlsiLyogZ2xvYmFsIGdsb2JhbDpyZWFkb25seSwgcHJvY2VzczpyZWFkb25seSAqL1xuLyogZXNsaW50IG5vLWVtcHR5OiBbXCJlcnJvclwiLCB7IFwiYWxsb3dFbXB0eUNhdGNoXCI6IHRydWUgfV0gKi9cblxuZnVuY3Rpb24gc2V0TWV0YVRhZyhuYW1lLCBjb250ZW50KSB7XG4gIHRyeSB7XG4gICAgY29uc3QgeyBkb2N1bWVudCB9ID0gZ2xvYmFsO1xuXG4gICAgaWYgKHR5cGVvZiBkb2N1bWVudCAhPT0gJ3VuZGVmaW5lZCcgJiYgZG9jdW1lbnQuY3JlYXRlRWxlbWVudCAmJiBkb2N1bWVudC5oZWFkICYmIGRvY3VtZW50LmhlYWQuYXBwZW5kQ2hpbGQpIHtcbiAgICAgIGNvbnN0IG1ldGEgPSBkb2N1bWVudC5xdWVyeVNlbGVjdG9yKGBodG1sIG1ldGFbbmFtZT1cIiR7ZW5jb2RlVVJJKG5hbWUpfVwiXWApIHx8IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ21ldGEnKTtcblxuICAgICAgbWV0YS5zZXRBdHRyaWJ1dGUoJ25hbWUnLCBuYW1lKTtcbiAgICAgIG1ldGEuc2V0QXR0cmlidXRlKCdjb250ZW50JywgY29udGVudCk7XG5cbiAgICAgIGRvY3VtZW50LmhlYWQuYXBwZW5kQ2hpbGQobWV0YSk7XG4gICAgfVxuICB9IGNhdGNoIChlcnIpIHt9XG59XG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGFkZFZlcnNpb25Ub01ldGFUYWcoKSB7XG4gIHNldE1ldGFUYWcoJ3JlYWN0LXNjcm9sbC10by1ib3R0b206dmVyc2lvbicsIHByb2Nlc3MuZW52Lm5wbV9wYWNrYWdlX3ZlcnNpb24pO1xufVxuIl19