import classNames from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import AutoHideFollowButton from './ScrollToBottom/AutoHideFollowButton';
import Composer from './ScrollToBottom/Composer';
import Panel from './ScrollToBottom/Panel';
import useStyleToClassName from './hooks/internal/useStyleToClassName';
var ROOT_STYLE = {
  position: 'relative'
};

var BasicScrollToBottomCore = function BasicScrollToBottomCore(_ref) {
  var children = _ref.children,
      className = _ref.className,
      followButtonClassName = _ref.followButtonClassName,
      scrollViewClassName = _ref.scrollViewClassName;
  var rootCSS = useStyleToClassName()(ROOT_STYLE);
  return /*#__PURE__*/React.createElement("div", {
    className: classNames(rootCSS, (className || '') + '')
  }, /*#__PURE__*/React.createElement(Panel, {
    className: (scrollViewClassName || '') + ''
  }, children), /*#__PURE__*/React.createElement(AutoHideFollowButton, {
    className: (followButtonClassName || '') + ''
  }));
};

BasicScrollToBottomCore.defaultProps = {
  children: undefined,
  className: undefined,
  followButtonClassName: undefined,
  scrollViewClassName: undefined
};
BasicScrollToBottomCore.propTypes = {
  children: PropTypes.any,
  className: PropTypes.string,
  followButtonClassName: PropTypes.string,
  scrollViewClassName: PropTypes.string
};

var BasicScrollToBottom = function BasicScrollToBottom(_ref2) {
  var checkInterval = _ref2.checkInterval,
      children = _ref2.children,
      className = _ref2.className,
      debounce = _ref2.debounce,
      debug = _ref2.debug,
      followButtonClassName = _ref2.followButtonClassName,
      initialScrollBehavior = _ref2.initialScrollBehavior,
      mode = _ref2.mode,
      nonce = _ref2.nonce,
      scroller = _ref2.scroller,
      scrollViewClassName = _ref2.scrollViewClassName;
  return /*#__PURE__*/React.createElement(Composer, {
    checkInterval: checkInterval,
    debounce: debounce,
    debug: debug,
    initialScrollBehavior: initialScrollBehavior,
    mode: mode,
    nonce: nonce,
    scroller: scroller
  }, /*#__PURE__*/React.createElement(BasicScrollToBottomCore, {
    className: className,
    followButtonClassName: followButtonClassName,
    scrollViewClassName: scrollViewClassName
  }, children));
};

BasicScrollToBottom.defaultProps = {
  checkInterval: undefined,
  children: undefined,
  className: undefined,
  debounce: undefined,
  debug: undefined,
  followButtonClassName: undefined,
  initialScrollBehavior: 'smooth',
  mode: undefined,
  nonce: undefined,
  scroller: undefined,
  scrollViewClassName: undefined
};
BasicScrollToBottom.propTypes = {
  checkInterval: PropTypes.number,
  children: PropTypes.any,
  className: PropTypes.string,
  debounce: PropTypes.number,
  debug: PropTypes.bool,
  followButtonClassName: PropTypes.string,
  initialScrollBehavior: PropTypes.oneOf(['auto', 'smooth']),
  mode: PropTypes.oneOf(['bottom', 'top']),
  nonce: PropTypes.string,
  scroller: PropTypes.func,
  scrollViewClassName: PropTypes.string
};
export default BasicScrollToBottom;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9CYXNpY1Njcm9sbFRvQm90dG9tLmpzIl0sIm5hbWVzIjpbImNsYXNzTmFtZXMiLCJQcm9wVHlwZXMiLCJSZWFjdCIsIkF1dG9IaWRlRm9sbG93QnV0dG9uIiwiQ29tcG9zZXIiLCJQYW5lbCIsInVzZVN0eWxlVG9DbGFzc05hbWUiLCJST09UX1NUWUxFIiwicG9zaXRpb24iLCJCYXNpY1Njcm9sbFRvQm90dG9tQ29yZSIsImNoaWxkcmVuIiwiY2xhc3NOYW1lIiwiZm9sbG93QnV0dG9uQ2xhc3NOYW1lIiwic2Nyb2xsVmlld0NsYXNzTmFtZSIsInJvb3RDU1MiLCJkZWZhdWx0UHJvcHMiLCJ1bmRlZmluZWQiLCJwcm9wVHlwZXMiLCJhbnkiLCJzdHJpbmciLCJCYXNpY1Njcm9sbFRvQm90dG9tIiwiY2hlY2tJbnRlcnZhbCIsImRlYm91bmNlIiwiZGVidWciLCJpbml0aWFsU2Nyb2xsQmVoYXZpb3IiLCJtb2RlIiwibm9uY2UiLCJzY3JvbGxlciIsIm51bWJlciIsImJvb2wiLCJvbmVPZiIsImZ1bmMiXSwibWFwcGluZ3MiOiJBQUFBLE9BQU9BLFVBQVAsTUFBdUIsWUFBdkI7QUFDQSxPQUFPQyxTQUFQLE1BQXNCLFlBQXRCO0FBQ0EsT0FBT0MsS0FBUCxNQUFrQixPQUFsQjtBQUVBLE9BQU9DLG9CQUFQLE1BQWlDLHVDQUFqQztBQUNBLE9BQU9DLFFBQVAsTUFBcUIsMkJBQXJCO0FBQ0EsT0FBT0MsS0FBUCxNQUFrQix3QkFBbEI7QUFDQSxPQUFPQyxtQkFBUCxNQUFnQyxzQ0FBaEM7QUFFQSxJQUFNQyxVQUFVLEdBQUc7QUFDakJDLEVBQUFBLFFBQVEsRUFBRTtBQURPLENBQW5COztBQUlBLElBQU1DLHVCQUF1QixHQUFHLFNBQTFCQSx1QkFBMEIsT0FBeUU7QUFBQSxNQUF0RUMsUUFBc0UsUUFBdEVBLFFBQXNFO0FBQUEsTUFBNURDLFNBQTRELFFBQTVEQSxTQUE0RDtBQUFBLE1BQWpEQyxxQkFBaUQsUUFBakRBLHFCQUFpRDtBQUFBLE1BQTFCQyxtQkFBMEIsUUFBMUJBLG1CQUEwQjtBQUN2RyxNQUFNQyxPQUFPLEdBQUdSLG1CQUFtQixHQUFHQyxVQUFILENBQW5DO0FBRUEsc0JBQ0U7QUFBSyxJQUFBLFNBQVMsRUFBRVAsVUFBVSxDQUFDYyxPQUFELEVBQVUsQ0FBQ0gsU0FBUyxJQUFJLEVBQWQsSUFBb0IsRUFBOUI7QUFBMUIsa0JBQ0Usb0JBQUMsS0FBRDtBQUFPLElBQUEsU0FBUyxFQUFFLENBQUNFLG1CQUFtQixJQUFJLEVBQXhCLElBQThCO0FBQWhELEtBQXFESCxRQUFyRCxDQURGLGVBRUUsb0JBQUMsb0JBQUQ7QUFBc0IsSUFBQSxTQUFTLEVBQUUsQ0FBQ0UscUJBQXFCLElBQUksRUFBMUIsSUFBZ0M7QUFBakUsSUFGRixDQURGO0FBTUQsQ0FURDs7QUFXQUgsdUJBQXVCLENBQUNNLFlBQXhCLEdBQXVDO0FBQ3JDTCxFQUFBQSxRQUFRLEVBQUVNLFNBRDJCO0FBRXJDTCxFQUFBQSxTQUFTLEVBQUVLLFNBRjBCO0FBR3JDSixFQUFBQSxxQkFBcUIsRUFBRUksU0FIYztBQUlyQ0gsRUFBQUEsbUJBQW1CLEVBQUVHO0FBSmdCLENBQXZDO0FBT0FQLHVCQUF1QixDQUFDUSxTQUF4QixHQUFvQztBQUNsQ1AsRUFBQUEsUUFBUSxFQUFFVCxTQUFTLENBQUNpQixHQURjO0FBRWxDUCxFQUFBQSxTQUFTLEVBQUVWLFNBQVMsQ0FBQ2tCLE1BRmE7QUFHbENQLEVBQUFBLHFCQUFxQixFQUFFWCxTQUFTLENBQUNrQixNQUhDO0FBSWxDTixFQUFBQSxtQkFBbUIsRUFBRVosU0FBUyxDQUFDa0I7QUFKRyxDQUFwQzs7QUFPQSxJQUFNQyxtQkFBbUIsR0FBRyxTQUF0QkEsbUJBQXNCO0FBQUEsTUFDMUJDLGFBRDBCLFNBQzFCQSxhQUQwQjtBQUFBLE1BRTFCWCxRQUYwQixTQUUxQkEsUUFGMEI7QUFBQSxNQUcxQkMsU0FIMEIsU0FHMUJBLFNBSDBCO0FBQUEsTUFJMUJXLFFBSjBCLFNBSTFCQSxRQUowQjtBQUFBLE1BSzFCQyxLQUwwQixTQUsxQkEsS0FMMEI7QUFBQSxNQU0xQlgscUJBTjBCLFNBTTFCQSxxQkFOMEI7QUFBQSxNQU8xQlkscUJBUDBCLFNBTzFCQSxxQkFQMEI7QUFBQSxNQVExQkMsSUFSMEIsU0FRMUJBLElBUjBCO0FBQUEsTUFTMUJDLEtBVDBCLFNBUzFCQSxLQVQwQjtBQUFBLE1BVTFCQyxRQVYwQixTQVUxQkEsUUFWMEI7QUFBQSxNQVcxQmQsbUJBWDBCLFNBVzFCQSxtQkFYMEI7QUFBQSxzQkFhMUIsb0JBQUMsUUFBRDtBQUNFLElBQUEsYUFBYSxFQUFFUSxhQURqQjtBQUVFLElBQUEsUUFBUSxFQUFFQyxRQUZaO0FBR0UsSUFBQSxLQUFLLEVBQUVDLEtBSFQ7QUFJRSxJQUFBLHFCQUFxQixFQUFFQyxxQkFKekI7QUFLRSxJQUFBLElBQUksRUFBRUMsSUFMUjtBQU1FLElBQUEsS0FBSyxFQUFFQyxLQU5UO0FBT0UsSUFBQSxRQUFRLEVBQUVDO0FBUFosa0JBU0Usb0JBQUMsdUJBQUQ7QUFDRSxJQUFBLFNBQVMsRUFBRWhCLFNBRGI7QUFFRSxJQUFBLHFCQUFxQixFQUFFQyxxQkFGekI7QUFHRSxJQUFBLG1CQUFtQixFQUFFQztBQUh2QixLQUtHSCxRQUxILENBVEYsQ0FiMEI7QUFBQSxDQUE1Qjs7QUFnQ0FVLG1CQUFtQixDQUFDTCxZQUFwQixHQUFtQztBQUNqQ00sRUFBQUEsYUFBYSxFQUFFTCxTQURrQjtBQUVqQ04sRUFBQUEsUUFBUSxFQUFFTSxTQUZ1QjtBQUdqQ0wsRUFBQUEsU0FBUyxFQUFFSyxTQUhzQjtBQUlqQ00sRUFBQUEsUUFBUSxFQUFFTixTQUp1QjtBQUtqQ08sRUFBQUEsS0FBSyxFQUFFUCxTQUwwQjtBQU1qQ0osRUFBQUEscUJBQXFCLEVBQUVJLFNBTlU7QUFPakNRLEVBQUFBLHFCQUFxQixFQUFFLFFBUFU7QUFRakNDLEVBQUFBLElBQUksRUFBRVQsU0FSMkI7QUFTakNVLEVBQUFBLEtBQUssRUFBRVYsU0FUMEI7QUFVakNXLEVBQUFBLFFBQVEsRUFBRVgsU0FWdUI7QUFXakNILEVBQUFBLG1CQUFtQixFQUFFRztBQVhZLENBQW5DO0FBY0FJLG1CQUFtQixDQUFDSCxTQUFwQixHQUFnQztBQUM5QkksRUFBQUEsYUFBYSxFQUFFcEIsU0FBUyxDQUFDMkIsTUFESztBQUU5QmxCLEVBQUFBLFFBQVEsRUFBRVQsU0FBUyxDQUFDaUIsR0FGVTtBQUc5QlAsRUFBQUEsU0FBUyxFQUFFVixTQUFTLENBQUNrQixNQUhTO0FBSTlCRyxFQUFBQSxRQUFRLEVBQUVyQixTQUFTLENBQUMyQixNQUpVO0FBSzlCTCxFQUFBQSxLQUFLLEVBQUV0QixTQUFTLENBQUM0QixJQUxhO0FBTTlCakIsRUFBQUEscUJBQXFCLEVBQUVYLFNBQVMsQ0FBQ2tCLE1BTkg7QUFPOUJLLEVBQUFBLHFCQUFxQixFQUFFdkIsU0FBUyxDQUFDNkIsS0FBVixDQUFnQixDQUFDLE1BQUQsRUFBUyxRQUFULENBQWhCLENBUE87QUFROUJMLEVBQUFBLElBQUksRUFBRXhCLFNBQVMsQ0FBQzZCLEtBQVYsQ0FBZ0IsQ0FBQyxRQUFELEVBQVcsS0FBWCxDQUFoQixDQVJ3QjtBQVM5QkosRUFBQUEsS0FBSyxFQUFFekIsU0FBUyxDQUFDa0IsTUFUYTtBQVU5QlEsRUFBQUEsUUFBUSxFQUFFMUIsU0FBUyxDQUFDOEIsSUFWVTtBQVc5QmxCLEVBQUFBLG1CQUFtQixFQUFFWixTQUFTLENBQUNrQjtBQVhELENBQWhDO0FBY0EsZUFBZUMsbUJBQWYiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgY2xhc3NOYW1lcyBmcm9tICdjbGFzc25hbWVzJztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuXG5pbXBvcnQgQXV0b0hpZGVGb2xsb3dCdXR0b24gZnJvbSAnLi9TY3JvbGxUb0JvdHRvbS9BdXRvSGlkZUZvbGxvd0J1dHRvbic7XG5pbXBvcnQgQ29tcG9zZXIgZnJvbSAnLi9TY3JvbGxUb0JvdHRvbS9Db21wb3Nlcic7XG5pbXBvcnQgUGFuZWwgZnJvbSAnLi9TY3JvbGxUb0JvdHRvbS9QYW5lbCc7XG5pbXBvcnQgdXNlU3R5bGVUb0NsYXNzTmFtZSBmcm9tICcuL2hvb2tzL2ludGVybmFsL3VzZVN0eWxlVG9DbGFzc05hbWUnO1xuXG5jb25zdCBST09UX1NUWUxFID0ge1xuICBwb3NpdGlvbjogJ3JlbGF0aXZlJ1xufTtcblxuY29uc3QgQmFzaWNTY3JvbGxUb0JvdHRvbUNvcmUgPSAoeyBjaGlsZHJlbiwgY2xhc3NOYW1lLCBmb2xsb3dCdXR0b25DbGFzc05hbWUsIHNjcm9sbFZpZXdDbGFzc05hbWUgfSkgPT4ge1xuICBjb25zdCByb290Q1NTID0gdXNlU3R5bGVUb0NsYXNzTmFtZSgpKFJPT1RfU1RZTEUpO1xuXG4gIHJldHVybiAoXG4gICAgPGRpdiBjbGFzc05hbWU9e2NsYXNzTmFtZXMocm9vdENTUywgKGNsYXNzTmFtZSB8fCAnJykgKyAnJyl9PlxuICAgICAgPFBhbmVsIGNsYXNzTmFtZT17KHNjcm9sbFZpZXdDbGFzc05hbWUgfHwgJycpICsgJyd9PntjaGlsZHJlbn08L1BhbmVsPlxuICAgICAgPEF1dG9IaWRlRm9sbG93QnV0dG9uIGNsYXNzTmFtZT17KGZvbGxvd0J1dHRvbkNsYXNzTmFtZSB8fCAnJykgKyAnJ30gLz5cbiAgICA8L2Rpdj5cbiAgKTtcbn07XG5cbkJhc2ljU2Nyb2xsVG9Cb3R0b21Db3JlLmRlZmF1bHRQcm9wcyA9IHtcbiAgY2hpbGRyZW46IHVuZGVmaW5lZCxcbiAgY2xhc3NOYW1lOiB1bmRlZmluZWQsXG4gIGZvbGxvd0J1dHRvbkNsYXNzTmFtZTogdW5kZWZpbmVkLFxuICBzY3JvbGxWaWV3Q2xhc3NOYW1lOiB1bmRlZmluZWRcbn07XG5cbkJhc2ljU2Nyb2xsVG9Cb3R0b21Db3JlLnByb3BUeXBlcyA9IHtcbiAgY2hpbGRyZW46IFByb3BUeXBlcy5hbnksXG4gIGNsYXNzTmFtZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgZm9sbG93QnV0dG9uQ2xhc3NOYW1lOiBQcm9wVHlwZXMuc3RyaW5nLFxuICBzY3JvbGxWaWV3Q2xhc3NOYW1lOiBQcm9wVHlwZXMuc3RyaW5nXG59O1xuXG5jb25zdCBCYXNpY1Njcm9sbFRvQm90dG9tID0gKHtcbiAgY2hlY2tJbnRlcnZhbCxcbiAgY2hpbGRyZW4sXG4gIGNsYXNzTmFtZSxcbiAgZGVib3VuY2UsXG4gIGRlYnVnLFxuICBmb2xsb3dCdXR0b25DbGFzc05hbWUsXG4gIGluaXRpYWxTY3JvbGxCZWhhdmlvcixcbiAgbW9kZSxcbiAgbm9uY2UsXG4gIHNjcm9sbGVyLFxuICBzY3JvbGxWaWV3Q2xhc3NOYW1lXG59KSA9PiAoXG4gIDxDb21wb3NlclxuICAgIGNoZWNrSW50ZXJ2YWw9e2NoZWNrSW50ZXJ2YWx9XG4gICAgZGVib3VuY2U9e2RlYm91bmNlfVxuICAgIGRlYnVnPXtkZWJ1Z31cbiAgICBpbml0aWFsU2Nyb2xsQmVoYXZpb3I9e2luaXRpYWxTY3JvbGxCZWhhdmlvcn1cbiAgICBtb2RlPXttb2RlfVxuICAgIG5vbmNlPXtub25jZX1cbiAgICBzY3JvbGxlcj17c2Nyb2xsZXJ9XG4gID5cbiAgICA8QmFzaWNTY3JvbGxUb0JvdHRvbUNvcmVcbiAgICAgIGNsYXNzTmFtZT17Y2xhc3NOYW1lfVxuICAgICAgZm9sbG93QnV0dG9uQ2xhc3NOYW1lPXtmb2xsb3dCdXR0b25DbGFzc05hbWV9XG4gICAgICBzY3JvbGxWaWV3Q2xhc3NOYW1lPXtzY3JvbGxWaWV3Q2xhc3NOYW1lfVxuICAgID5cbiAgICAgIHtjaGlsZHJlbn1cbiAgICA8L0Jhc2ljU2Nyb2xsVG9Cb3R0b21Db3JlPlxuICA8L0NvbXBvc2VyPlxuKTtcblxuQmFzaWNTY3JvbGxUb0JvdHRvbS5kZWZhdWx0UHJvcHMgPSB7XG4gIGNoZWNrSW50ZXJ2YWw6IHVuZGVmaW5lZCxcbiAgY2hpbGRyZW46IHVuZGVmaW5lZCxcbiAgY2xhc3NOYW1lOiB1bmRlZmluZWQsXG4gIGRlYm91bmNlOiB1bmRlZmluZWQsXG4gIGRlYnVnOiB1bmRlZmluZWQsXG4gIGZvbGxvd0J1dHRvbkNsYXNzTmFtZTogdW5kZWZpbmVkLFxuICBpbml0aWFsU2Nyb2xsQmVoYXZpb3I6ICdzbW9vdGgnLFxuICBtb2RlOiB1bmRlZmluZWQsXG4gIG5vbmNlOiB1bmRlZmluZWQsXG4gIHNjcm9sbGVyOiB1bmRlZmluZWQsXG4gIHNjcm9sbFZpZXdDbGFzc05hbWU6IHVuZGVmaW5lZFxufTtcblxuQmFzaWNTY3JvbGxUb0JvdHRvbS5wcm9wVHlwZXMgPSB7XG4gIGNoZWNrSW50ZXJ2YWw6IFByb3BUeXBlcy5udW1iZXIsXG4gIGNoaWxkcmVuOiBQcm9wVHlwZXMuYW55LFxuICBjbGFzc05hbWU6IFByb3BUeXBlcy5zdHJpbmcsXG4gIGRlYm91bmNlOiBQcm9wVHlwZXMubnVtYmVyLFxuICBkZWJ1ZzogUHJvcFR5cGVzLmJvb2wsXG4gIGZvbGxvd0J1dHRvbkNsYXNzTmFtZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgaW5pdGlhbFNjcm9sbEJlaGF2aW9yOiBQcm9wVHlwZXMub25lT2YoWydhdXRvJywgJ3Ntb290aCddKSxcbiAgbW9kZTogUHJvcFR5cGVzLm9uZU9mKFsnYm90dG9tJywgJ3RvcCddKSxcbiAgbm9uY2U6IFByb3BUeXBlcy5zdHJpbmcsXG4gIHNjcm9sbGVyOiBQcm9wVHlwZXMuZnVuYyxcbiAgc2Nyb2xsVmlld0NsYXNzTmFtZTogUHJvcFR5cGVzLnN0cmluZ1xufTtcblxuZXhwb3J0IGRlZmF1bHQgQmFzaWNTY3JvbGxUb0JvdHRvbTtcbiJdfQ==