import _Date$now from "@babel/runtime-corejs3/core-js-stable/date/now";
import "core-js/modules/es.function.name.js";
import { useCallback, useLayoutEffect, useMemo, useRef } from 'react';
import debounceFn from './debounce';

var EventSpy = function EventSpy(_ref) {
  var debounce = _ref.debounce,
      name = _ref.name,
      onEvent = _ref.onEvent,
      target = _ref.target;
  // We need to save the "onEvent" to ref.
  // This is because "onEvent" may change from time to time, but debounce may still fire to the older callback.
  var onEventRef = useRef();
  onEventRef.current = onEvent;
  var debouncer = useMemo(function () {
    return debounceFn(function (event) {
      var current = onEventRef.current;
      current && current(event);
    }, debounce);
  }, [debounce, onEventRef]);
  var handleEvent = useCallback(function (event) {
    event.timeStampLow = _Date$now();
    debouncer(event);
  }, [debouncer]);
  useLayoutEffect(function () {
    target.addEventListener(name, handleEvent, {
      passive: true
    });
    handleEvent({
      target: target,
      type: name
    });
    return function () {
      return target.removeEventListener(name, handleEvent);
    };
  }, [name, handleEvent, target]);
  return false;
};

EventSpy.defaultProps = {
  debounce: 200
};
export default EventSpy;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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