import _slicedToArray from "@babel/runtime-corejs3/helpers/slicedToArray";
import classNames from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import useScrollToEnd from '../hooks/useScrollToEnd';
import useSticky from '../hooks/useSticky';
import useStyleToClassName from '../hooks/internal/useStyleToClassName';
var ROOT_STYLE = {
  backgroundColor: 'rgba(0, 0, 0, .2)',
  borderRadius: 10,
  borderWidth: 0,
  bottom: 5,
  cursor: 'pointer',
  height: 20,
  outline: 0,
  position: 'absolute',
  right: 20,
  width: 20,
  '&:hover': {
    backgroundColor: 'rgba(0, 0, 0, .4)'
  },
  '&:active': {
    backgroundColor: 'rgba(0, 0, 0, .6)'
  }
};

var AutoHideFollowButton = function AutoHideFollowButton(_ref) {
  var children = _ref.children,
      className = _ref.className;

  var _useSticky = useSticky(),
      _useSticky2 = _slicedToArray(_useSticky, 1),
      sticky = _useSticky2[0];

  var rootCSS = useStyleToClassName()(ROOT_STYLE);
  var scrollToEnd = useScrollToEnd();
  return !sticky && /*#__PURE__*/React.createElement("button", {
    className: classNames(rootCSS, (className || '') + ''),
    onClick: scrollToEnd,
    type: "button"
  }, children);
};

AutoHideFollowButton.defaultProps = {
  children: undefined,
  className: ''
};
AutoHideFollowButton.propTypes = {
  children: PropTypes.any,
  className: PropTypes.string
};
export default AutoHideFollowButton;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9TY3JvbGxUb0JvdHRvbS9BdXRvSGlkZUZvbGxvd0J1dHRvbi5qcyJdLCJuYW1lcyI6WyJjbGFzc05hbWVzIiwiUHJvcFR5cGVzIiwiUmVhY3QiLCJ1c2VTY3JvbGxUb0VuZCIsInVzZVN0aWNreSIsInVzZVN0eWxlVG9DbGFzc05hbWUiLCJST09UX1NUWUxFIiwiYmFja2dyb3VuZENvbG9yIiwiYm9yZGVyUmFkaXVzIiwiYm9yZGVyV2lkdGgiLCJib3R0b20iLCJjdXJzb3IiLCJoZWlnaHQiLCJvdXRsaW5lIiwicG9zaXRpb24iLCJyaWdodCIsIndpZHRoIiwiQXV0b0hpZGVGb2xsb3dCdXR0b24iLCJjaGlsZHJlbiIsImNsYXNzTmFtZSIsInN0aWNreSIsInJvb3RDU1MiLCJzY3JvbGxUb0VuZCIsImRlZmF1bHRQcm9wcyIsInVuZGVmaW5lZCIsInByb3BUeXBlcyIsImFueSIsInN0cmluZyJdLCJtYXBwaW5ncyI6IjtBQUFBLE9BQU9BLFVBQVAsTUFBdUIsWUFBdkI7QUFDQSxPQUFPQyxTQUFQLE1BQXNCLFlBQXRCO0FBQ0EsT0FBT0MsS0FBUCxNQUFrQixPQUFsQjtBQUVBLE9BQU9DLGNBQVAsTUFBMkIseUJBQTNCO0FBQ0EsT0FBT0MsU0FBUCxNQUFzQixvQkFBdEI7QUFDQSxPQUFPQyxtQkFBUCxNQUFnQyx1Q0FBaEM7QUFFQSxJQUFNQyxVQUFVLEdBQUc7QUFDakJDLEVBQUFBLGVBQWUsRUFBRSxtQkFEQTtBQUVqQkMsRUFBQUEsWUFBWSxFQUFFLEVBRkc7QUFHakJDLEVBQUFBLFdBQVcsRUFBRSxDQUhJO0FBSWpCQyxFQUFBQSxNQUFNLEVBQUUsQ0FKUztBQUtqQkMsRUFBQUEsTUFBTSxFQUFFLFNBTFM7QUFNakJDLEVBQUFBLE1BQU0sRUFBRSxFQU5TO0FBT2pCQyxFQUFBQSxPQUFPLEVBQUUsQ0FQUTtBQVFqQkMsRUFBQUEsUUFBUSxFQUFFLFVBUk87QUFTakJDLEVBQUFBLEtBQUssRUFBRSxFQVRVO0FBVWpCQyxFQUFBQSxLQUFLLEVBQUUsRUFWVTtBQVlqQixhQUFXO0FBQ1RULElBQUFBLGVBQWUsRUFBRTtBQURSLEdBWk07QUFnQmpCLGNBQVk7QUFDVkEsSUFBQUEsZUFBZSxFQUFFO0FBRFA7QUFoQkssQ0FBbkI7O0FBcUJBLElBQU1VLG9CQUFvQixHQUFHLFNBQXZCQSxvQkFBdUIsT0FBNkI7QUFBQSxNQUExQkMsUUFBMEIsUUFBMUJBLFFBQTBCO0FBQUEsTUFBaEJDLFNBQWdCLFFBQWhCQSxTQUFnQjs7QUFDeEQsbUJBQWlCZixTQUFTLEVBQTFCO0FBQUE7QUFBQSxNQUFPZ0IsTUFBUDs7QUFDQSxNQUFNQyxPQUFPLEdBQUdoQixtQkFBbUIsR0FBR0MsVUFBSCxDQUFuQztBQUNBLE1BQU1nQixXQUFXLEdBQUduQixjQUFjLEVBQWxDO0FBRUEsU0FDRSxDQUFDaUIsTUFBRCxpQkFDRTtBQUFRLElBQUEsU0FBUyxFQUFFcEIsVUFBVSxDQUFDcUIsT0FBRCxFQUFVLENBQUNGLFNBQVMsSUFBSSxFQUFkLElBQW9CLEVBQTlCLENBQTdCO0FBQWdFLElBQUEsT0FBTyxFQUFFRyxXQUF6RTtBQUFzRixJQUFBLElBQUksRUFBQztBQUEzRixLQUNHSixRQURILENBRko7QUFPRCxDQVpEOztBQWNBRCxvQkFBb0IsQ0FBQ00sWUFBckIsR0FBb0M7QUFDbENMLEVBQUFBLFFBQVEsRUFBRU0sU0FEd0I7QUFFbENMLEVBQUFBLFNBQVMsRUFBRTtBQUZ1QixDQUFwQztBQUtBRixvQkFBb0IsQ0FBQ1EsU0FBckIsR0FBaUM7QUFDL0JQLEVBQUFBLFFBQVEsRUFBRWpCLFNBQVMsQ0FBQ3lCLEdBRFc7QUFFL0JQLEVBQUFBLFNBQVMsRUFBRWxCLFNBQVMsQ0FBQzBCO0FBRlUsQ0FBakM7QUFLQSxlQUFlVixvQkFBZiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBjbGFzc05hbWVzIGZyb20gJ2NsYXNzbmFtZXMnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5cbmltcG9ydCB1c2VTY3JvbGxUb0VuZCBmcm9tICcuLi9ob29rcy91c2VTY3JvbGxUb0VuZCc7XG5pbXBvcnQgdXNlU3RpY2t5IGZyb20gJy4uL2hvb2tzL3VzZVN0aWNreSc7XG5pbXBvcnQgdXNlU3R5bGVUb0NsYXNzTmFtZSBmcm9tICcuLi9ob29rcy9pbnRlcm5hbC91c2VTdHlsZVRvQ2xhc3NOYW1lJztcblxuY29uc3QgUk9PVF9TVFlMRSA9IHtcbiAgYmFja2dyb3VuZENvbG9yOiAncmdiYSgwLCAwLCAwLCAuMiknLFxuICBib3JkZXJSYWRpdXM6IDEwLFxuICBib3JkZXJXaWR0aDogMCxcbiAgYm90dG9tOiA1LFxuICBjdXJzb3I6ICdwb2ludGVyJyxcbiAgaGVpZ2h0OiAyMCxcbiAgb3V0bGluZTogMCxcbiAgcG9zaXRpb246ICdhYnNvbHV0ZScsXG4gIHJpZ2h0OiAyMCxcbiAgd2lkdGg6IDIwLFxuXG4gICcmOmhvdmVyJzoge1xuICAgIGJhY2tncm91bmRDb2xvcjogJ3JnYmEoMCwgMCwgMCwgLjQpJ1xuICB9LFxuXG4gICcmOmFjdGl2ZSc6IHtcbiAgICBiYWNrZ3JvdW5kQ29sb3I6ICdyZ2JhKDAsIDAsIDAsIC42KSdcbiAgfVxufTtcblxuY29uc3QgQXV0b0hpZGVGb2xsb3dCdXR0b24gPSAoeyBjaGlsZHJlbiwgY2xhc3NOYW1lIH0pID0+IHtcbiAgY29uc3QgW3N0aWNreV0gPSB1c2VTdGlja3koKTtcbiAgY29uc3Qgcm9vdENTUyA9IHVzZVN0eWxlVG9DbGFzc05hbWUoKShST09UX1NUWUxFKTtcbiAgY29uc3Qgc2Nyb2xsVG9FbmQgPSB1c2VTY3JvbGxUb0VuZCgpO1xuXG4gIHJldHVybiAoXG4gICAgIXN0aWNreSAmJiAoXG4gICAgICA8YnV0dG9uIGNsYXNzTmFtZT17Y2xhc3NOYW1lcyhyb290Q1NTLCAoY2xhc3NOYW1lIHx8ICcnKSArICcnKX0gb25DbGljaz17c2Nyb2xsVG9FbmR9IHR5cGU9XCJidXR0b25cIj5cbiAgICAgICAge2NoaWxkcmVufVxuICAgICAgPC9idXR0b24+XG4gICAgKVxuICApO1xufTtcblxuQXV0b0hpZGVGb2xsb3dCdXR0b24uZGVmYXVsdFByb3BzID0ge1xuICBjaGlsZHJlbjogdW5kZWZpbmVkLFxuICBjbGFzc05hbWU6ICcnXG59O1xuXG5BdXRvSGlkZUZvbGxvd0J1dHRvbi5wcm9wVHlwZXMgPSB7XG4gIGNoaWxkcmVuOiBQcm9wVHlwZXMuYW55LFxuICBjbGFzc05hbWU6IFByb3BUeXBlcy5zdHJpbmdcbn07XG5cbmV4cG9ydCBkZWZhdWx0IEF1dG9IaWRlRm9sbG93QnV0dG9uO1xuIl19