import _defineProperty from "@babel/runtime-corejs3/helpers/defineProperty";
import _toConsumableArray from "@babel/runtime-corejs3/helpers/toConsumableArray";
import _slicedToArray from "@babel/runtime-corejs3/helpers/slicedToArray";

function ownKeys(object, enumerableOnly) { var keys = _Object$keys(object); if (_Object$getOwnPropertySymbols) { var symbols = _Object$getOwnPropertySymbols(object); if (enumerableOnly) { symbols = _filterInstanceProperty(symbols).call(symbols, function (sym) { return _Object$getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { var _context21; _forEachInstanceProperty(_context21 = ownKeys(Object(source), true)).call(_context21, function (key) { _defineProperty(target, key, source[key]); }); } else if (_Object$getOwnPropertyDescriptors) { _Object$defineProperties(target, _Object$getOwnPropertyDescriptors(source)); } else { var _context22; _forEachInstanceProperty(_context22 = ownKeys(Object(source))).call(_context22, function (key) { _Object$defineProperty(target, key, _Object$getOwnPropertyDescriptor(source, key)); }); } } return target; }

import "core-js/modules/es.regexp.exec.js";
import "core-js/modules/es.string.replace.js";
import _setInterval from "@babel/runtime-corejs3/core-js-stable/set-interval";
import _indexOfInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/index-of";
import _spliceInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/splice";
import _concatInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/concat";
import _Date$now from "@babel/runtime-corejs3/core-js-stable/date/now";
import _forEachInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/for-each";
import _Object$keys from "@babel/runtime-corejs3/core-js-stable/object/keys";
import _Object$getOwnPropertySymbols from "@babel/runtime-corejs3/core-js-stable/object/get-own-property-symbols";
import _filterInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/filter";
import _Object$getOwnPropertyDescriptor from "@babel/runtime-corejs3/core-js-stable/object/get-own-property-descriptor";
import _Object$getOwnPropertyDescriptors from "@babel/runtime-corejs3/core-js-stable/object/get-own-property-descriptors";
import _Object$defineProperties from "@babel/runtime-corejs3/core-js-stable/object/define-properties";
import _Object$defineProperty from "@babel/runtime-corejs3/core-js-stable/object/define-property";
import createEmotion from '@emotion/css/create-instance';
import PropTypes from 'prop-types';
import React, { useCallback, useEffect, useMemo, useRef, useState } from 'react';
import createCSSKey from '../createCSSKey';
import createDebug from '../utils/debug';
import EventSpy from '../EventSpy';
import FunctionContext from './FunctionContext';
import InternalContext from './InternalContext';
import SpineTo from '../SpineTo';
import State1Context from './State1Context';
import State2Context from './State2Context';
import StateContext from './StateContext';
import styleConsole from '../utils/styleConsole';
import useStateRef from '../hooks/internal/useStateRef';

var DEFAULT_SCROLLER = function DEFAULT_SCROLLER() {
  return Infinity;
};

var MIN_CHECK_INTERVAL = 17; // 1 frame

var MODE_BOTTOM = 'bottom';
var MODE_TOP = 'top';
var NEAR_END_THRESHOLD = 1;
var SCROLL_DECISION_DURATION = 34; // 2 frames
// We pool the emotion object by nonce.
// This is to make sure we don't generate too many unneeded <style> tags.

var emotionPool = {};

function setImmediateInterval(fn, ms) {
  fn();
  return _setInterval(fn, ms);
}

function computeViewState(_ref) {
  var mode = _ref.mode,
      _ref$target = _ref.target,
      offsetHeight = _ref$target.offsetHeight,
      scrollHeight = _ref$target.scrollHeight,
      scrollTop = _ref$target.scrollTop;
  var atBottom = scrollHeight - scrollTop - offsetHeight < NEAR_END_THRESHOLD;
  var atTop = scrollTop < NEAR_END_THRESHOLD;
  var atEnd = mode === MODE_TOP ? atTop : atBottom;
  var atStart = mode !== MODE_TOP ? atTop : atBottom;
  return {
    atBottom: atBottom,
    atEnd: atEnd,
    atStart: atStart,
    atTop: atTop
  };
}

function isEnd(animateTo, mode) {
  return animateTo === (mode === MODE_TOP ? 0 : '100%');
}

var Composer = function Composer(_ref2) {
  var checkInterval = _ref2.checkInterval,
      children = _ref2.children,
      debounce = _ref2.debounce,
      debugFromProp = _ref2.debug,
      initialScrollBehavior = _ref2.initialScrollBehavior,
      mode = _ref2.mode,
      nonce = _ref2.nonce,
      scroller = _ref2.scroller;
  var debug = useMemo(function () {
    return createDebug("<ScrollToBottom>", {
      force: debugFromProp
    });
  }, [debugFromProp]);
  mode = mode === MODE_TOP ? MODE_TOP : MODE_BOTTOM;
  var ignoreScrollEventBeforeRef = useRef(0);
  var initialScrollBehaviorRef = useRef(initialScrollBehavior);

  var _useStateRef = useStateRef(mode === MODE_TOP ? 0 : '100%'),
      _useStateRef2 = _slicedToArray(_useStateRef, 3),
      animateTo = _useStateRef2[0],
      setAnimateTo = _useStateRef2[1],
      animateToRef = _useStateRef2[2];

  var _useStateRef3 = useStateRef(null),
      _useStateRef4 = _slicedToArray(_useStateRef3, 3),
      target = _useStateRef4[0],
      setTarget = _useStateRef4[1],
      targetRef = _useStateRef4[2]; // Internal context


  var animateFromRef = useRef(0);
  var offsetHeightRef = useRef(0);
  var scrollHeightRef = useRef(0); // State context

  var _useState = useState(true),
      _useState2 = _slicedToArray(_useState, 2),
      atBottom = _useState2[0],
      setAtBottom = _useState2[1];

  var _useState3 = useState(true),
      _useState4 = _slicedToArray(_useState3, 2),
      atEnd = _useState4[0],
      setAtEnd = _useState4[1];

  var _useState5 = useState(true),
      _useState6 = _slicedToArray(_useState5, 2),
      atTop = _useState6[0],
      setAtTop = _useState6[1];

  var _useState7 = useState(false),
      _useState8 = _slicedToArray(_useState7, 2),
      atStart = _useState8[0],
      setAtStart = _useState8[1];

  var _useStateRef5 = useStateRef(true),
      _useStateRef6 = _slicedToArray(_useStateRef5, 3),
      sticky = _useStateRef6[0],
      setSticky = _useStateRef6[1],
      stickyRef = _useStateRef6[2]; // High-rate state context


  var scrollPositionObserversRef = useRef([]);
  var observeScrollPosition = useCallback(function (fn) {
    var target = targetRef.current;
    scrollPositionObserversRef.current.push(fn);
    target && fn({
      scrollTop: target.scrollTop
    });
    return function () {
      var scrollPositionObservers = scrollPositionObserversRef.current;

      var index = _indexOfInstanceProperty(scrollPositionObservers).call(scrollPositionObservers, fn);

      ~index && _spliceInstanceProperty(scrollPositionObservers).call(scrollPositionObservers, index, 1);
    };
  }, [scrollPositionObserversRef, targetRef]);
  var handleSpineToEnd = useCallback(function () {
    var animateTo = animateToRef.current;
    debug(function () {
      var _context;

      return _concatInstanceProperty(_context = ['%cSpineTo%c: %conEnd%c is fired.']).call(_context, _toConsumableArray(styleConsole('magenta')), _toConsumableArray(styleConsole('orange')), [{
        animateTo: animateTo
      }]);
    });
    ignoreScrollEventBeforeRef.current = _Date$now(); // handleScrollEnd may end at a position which should lose stickiness.
    // In that case, we will need to set sticky to false to stop the interval check.
    // Test case:
    // 1. Add a scroller that always return 0
    // 2. Show a panel with mode === MODE_BOTTOM
    // 3. Programmatically scroll to 0 (set element.scrollTop = 0)
    // Expected: it should not repetitively call scrollTo(0)
    //           it should set stickiness to false

    isEnd(animateTo, mode) || setSticky(false);
    setAnimateTo(null);
  }, [animateToRef, debug, ignoreScrollEventBeforeRef, mode, setAnimateTo, setSticky]); // Function context

  var scrollTo = useCallback(function (nextAnimateTo) {
    var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        behavior = _ref3.behavior;

    var target = targetRef.current;

    if (typeof nextAnimateTo !== 'number' && nextAnimateTo !== '100%') {
      return console.warn('react-scroll-to-bottom: Arguments passed to scrollTo() must be either number or "100%".');
    } // If it is trying to scroll to a position which is not "atEnd", it should set sticky to false after scroll ended.


    debug(function () {
      var _context2;

      return [_concatInstanceProperty(_context2 = ["%cscrollTo%c: Will scroll to %c".concat(typeof nextAnimateTo === 'number' ? nextAnimateTo + 'px' : nextAnimateTo.replace(/%/g, '%%'), "%c")]).call(_context2, _toConsumableArray(styleConsole('lime', '')), _toConsumableArray(styleConsole('purple'))), {
        behavior: behavior,
        nextAnimateTo: nextAnimateTo,
        target: target
      }];
    });

    if (behavior === 'auto') {
      // Stop any existing animation
      handleSpineToEnd();

      if (target) {
        // Jump to the scroll position
        target.scrollTop = nextAnimateTo === '100%' ? target.scrollHeight - target.offsetHeight : nextAnimateTo;
      }
    } else {
      behavior !== 'smooth' && console.warn('react-scroll-to-bottom: Please set "behavior" when calling "scrollTo". In future versions, the default behavior will be changed from smooth scrolling to discrete scrolling to align with HTML Standard.');
      setAnimateTo(nextAnimateTo);
    } // This is for handling a case. When calling scrollTo('100%', { behavior: 'auto' }) multiple times, it would lose stickiness.


    if (isEnd(nextAnimateTo, mode)) {
      debug(function () {
        var _context3;

        return [_concatInstanceProperty(_context3 = ["%cscrollTo%c: Scrolling to end, will set sticky to %ctrue%c."]).call(_context3, _toConsumableArray(styleConsole('lime', '')), _toConsumableArray(styleConsole('purple'))), [{
          mode: mode,
          nextAnimateTo: nextAnimateTo
        }]];
      });
      setSticky(true);
    }
  }, [debug, handleSpineToEnd, mode, setAnimateTo, setSticky, targetRef]);
  var scrollToBottom = useCallback(function () {
    var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        behavior = _ref4.behavior;

    debug(function () {
      var _context4;

      return _concatInstanceProperty(_context4 = ['%cscrollToBottom%c: Called']).call(_context4, _toConsumableArray(styleConsole('yellow', '')));
    });
    behavior !== 'smooth' && console.warn('react-scroll-to-bottom: Please set "behavior" when calling "scrollToBottom". In future versions, the default behavior will be changed from smooth scrolling to discrete scrolling to align with HTML Standard.');
    scrollTo('100%', {
      behavior: behavior || 'smooth'
    });
  }, [debug, scrollTo]);
  var scrollToTop = useCallback(function () {
    var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        behavior = _ref5.behavior;

    debug(function () {
      var _context5;

      return _concatInstanceProperty(_context5 = ['%cscrollToTop%c: Called']).call(_context5, _toConsumableArray(styleConsole('yellow', '')));
    });
    behavior !== 'smooth' && console.warn('react-scroll-to-bottom: Please set "behavior" when calling "scrollToTop". In future versions, the default behavior will be changed from smooth scrolling to discrete scrolling to align with HTML Standard.');
    scrollTo(0, {
      behavior: behavior || 'smooth'
    });
  }, [debug, scrollTo]);
  var scrollToEnd = useCallback(function () {
    var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        behavior = _ref6.behavior;

    debug(function () {
      var _context6;

      return _concatInstanceProperty(_context6 = ['%cscrollToEnd%c: Called']).call(_context6, _toConsumableArray(styleConsole('yellow', '')));
    });
    behavior !== 'smooth' && console.warn('react-scroll-to-bottom: Please set "behavior" when calling "scrollToEnd". In future versions, the default behavior will be changed from smooth scrolling to discrete scrolling to align with HTML Standard.');
    var options = {
      behavior: behavior || 'smooth'
    };
    mode === MODE_TOP ? scrollToTop(options) : scrollToBottom(options);
  }, [debug, mode, scrollToBottom, scrollToTop]);
  var scrollToStart = useCallback(function () {
    var _ref7 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        behavior = _ref7.behavior;

    debug(function () {
      var _context7;

      return _concatInstanceProperty(_context7 = ['%cscrollToStart%c: Called']).call(_context7, _toConsumableArray(styleConsole('yellow', '')));
    });
    behavior !== 'smooth' && console.warn('react-scroll-to-bottom: Please set "behavior" when calling "scrollToStart". In future versions, the default behavior will be changed from smooth scrolling to discrete scrolling to align with HTML Standard.');
    var options = {
      behavior: behavior || 'smooth'
    };
    mode === MODE_TOP ? scrollToBottom(options) : scrollToTop(options);
  }, [debug, mode, scrollToBottom, scrollToTop]);
  var scrollToSticky = useCallback(function () {
    var target = targetRef.current;

    if (target) {
      if (initialScrollBehaviorRef.current === 'auto') {
        debug(function () {
          var _context8;

          return _concatInstanceProperty(_context8 = ["%ctarget changed%c: Initial scroll"]).call(_context8, _toConsumableArray(styleConsole('blue')));
        });
        target.scrollTop = mode === MODE_TOP ? 0 : target.scrollHeight - target.offsetHeight;
        initialScrollBehaviorRef.current = false;
        return;
      } // This is very similar to scrollToEnd().
      // Instead of scrolling to end, it will call props.scroller() to determines how far it should scroll.
      // This function could be called while it is auto-scrolling.


      var animateFrom = animateFromRef.current;
      var offsetHeight = target.offsetHeight,
          scrollHeight = target.scrollHeight,
          scrollTop = target.scrollTop;
      var maxValue = mode === MODE_TOP ? 0 : Math.max(0, scrollHeight - offsetHeight - scrollTop);
      var minValue = Math.max(0, animateFrom - scrollTop);
      var rawNextValue = scroller({
        maxValue: maxValue,
        minValue: minValue,
        offsetHeight: offsetHeight,
        scrollHeight: scrollHeight,
        scrollTop: scrollTop
      });
      var nextValue = Math.max(0, Math.min(maxValue, rawNextValue));
      var nextAnimateTo;

      if (mode === MODE_TOP || nextValue !== maxValue) {
        nextAnimateTo = scrollTop + nextValue;
      } else {
        // When scrolling to bottom, we should scroll to "100%".
        // Otherwise, if we scroll to any number, it will lose stickiness when elements are adding too fast.
        // "100%" is a special argument intended to make sure stickiness is not lost while new elements are being added.
        nextAnimateTo = '100%';
      }

      debug(function () {
        var _context9, _context10, _context11;

        return [_concatInstanceProperty(_context9 = [_concatInstanceProperty(_context10 = _concatInstanceProperty(_context11 = "%cscrollToSticky%c: Will animate from %c".concat(animateFrom, "px%c to %c")).call(_context11, typeof nextAnimateTo === 'number' ? nextAnimateTo + 'px' : nextAnimateTo.replace(/%/g, '%%'), "%c (%c")).call(_context10, (nextAnimateTo === '100%' ? maxValue : nextAnimateTo) + animateFrom, "px%c)")]).call(_context9, _toConsumableArray(styleConsole('orange')), _toConsumableArray(styleConsole('purple')), _toConsumableArray(styleConsole('purple')), _toConsumableArray(styleConsole('purple'))), {
          animateFrom: animateFrom,
          maxValue: maxValue,
          minValue: minValue,
          nextAnimateTo: nextAnimateTo,
          nextValue: nextValue,
          offsetHeight: offsetHeight,
          rawNextValue: rawNextValue,
          scrollHeight: scrollHeight,
          scrollTop: scrollTop
        }];
      });
      scrollTo(nextAnimateTo, {
        behavior: 'smooth'
      });
    }
  }, [animateFromRef, debug, mode, scroller, scrollTo, targetRef]);
  var handleScroll = useCallback(function (_ref8) {
    var _context17;

    var timeStampLow = _ref8.timeStampLow;
    var animateTo = animateToRef.current;
    var target = targetRef.current;
    var animating = animateTo !== null; // Currently, there are no reliable way to check if the "scroll" event is trigger due to
    // user gesture, programmatic scrolling, or Chrome-synthesized "scroll" event to compensate size change.
    // Thus, we use our best-effort to guess if it is triggered by user gesture, and disable sticky if it is heading towards the start direction.

    if (timeStampLow <= ignoreScrollEventBeforeRef.current || !target) {
      // Since we debounce "scroll" event, this handler might be called after spineTo.onEnd (a.k.a. artificial scrolling).
      // We should ignore debounced event fired after scrollEnd, because without skipping them, the userInitiatedScroll calculated below will not be accurate.
      // Thus, on a fast machine, adding elements super fast will lose the "stickiness".
      return;
    }

    var _computeViewState = computeViewState({
      mode: mode,
      target: target
    }),
        atBottom = _computeViewState.atBottom,
        atEnd = _computeViewState.atEnd,
        atStart = _computeViewState.atStart,
        atTop = _computeViewState.atTop;

    setAtBottom(atBottom);
    setAtEnd(atEnd);
    setAtStart(atStart);
    setAtTop(atTop); // Chrome will emit "synthetic" scroll event if the container is resized or an element is added
    // We need to ignore these "synthetic" events
    // Repro: In playground, press 4-1-5-1-1 (small, add one, normal, add one, add one)
    //        Nomatter how fast or slow the sequence is being pressed, it should still stick to the bottom

    var nextOffsetHeight = target.offsetHeight,
        nextScrollHeight = target.scrollHeight;
    var offsetHeight = offsetHeightRef.current;
    var scrollHeight = scrollHeightRef.current;
    var offsetHeightChanged = nextOffsetHeight !== offsetHeight;
    var scrollHeightChanged = nextScrollHeight !== scrollHeight;

    if (offsetHeightChanged) {
      offsetHeightRef.current = nextOffsetHeight;
    }

    if (scrollHeightChanged) {
      scrollHeightRef.current = nextScrollHeight;
    } // Sticky means:
    // - If it is scrolled programatically, we are still in sticky mode
    // - If it is scrolled by the user, then sticky means if we are at the end
    // Only update stickiness if the scroll event is not due to synthetic scroll done by Chrome


    if (!offsetHeightChanged && !scrollHeightChanged) {
      // We are sticky if we are animating to the end, or we are already at the end.
      // We can be "animating but not sticky" by calling "scrollTo(100)" where the container scrollHeight is 200px.
      var nextSticky = animating && isEnd(animateTo, mode) || atEnd;

      if (stickyRef.current !== nextSticky) {
        debug(function () {
          var _context12, _context13, _context14, _context15;

          return [_concatInstanceProperty(_context12 = ["%conScroll%c: %csetSticky%c(%c".concat(nextSticky, "%c)")]).call(_context12, _toConsumableArray(styleConsole('red')), _toConsumableArray(styleConsole('red')), _toConsumableArray(styleConsole('purple'))), _concatInstanceProperty(_context13 = [_concatInstanceProperty(_context14 = _concatInstanceProperty(_context15 = "(animating = %c".concat(animating, "%c && isEnd = %c")).call(_context15, isEnd(animateTo, mode), "%c) || atEnd = %c")).call(_context14, atEnd, "%c")]).call(_context13, _toConsumableArray(styleConsole('purple')), _toConsumableArray(styleConsole('purple')), _toConsumableArray(styleConsole('purple')), [{
            animating: animating,
            animateTo: animateTo,
            atEnd: atEnd,
            mode: mode,
            offsetHeight: target.offsetHeight,
            scrollHeight: target.scrollHeight,
            sticky: stickyRef.current,
            nextSticky: nextSticky
          }])];
        });
        setSticky(nextSticky);
      }
    } else if (stickyRef.current) {
      debug(function () {
        var _context16;

        return [_concatInstanceProperty(_context16 = ["%conScroll%c: Size changed while sticky, calling %cscrollToSticky()%c"]).call(_context16, _toConsumableArray(styleConsole('red')), _toConsumableArray(styleConsole('orange')), [{
          offsetHeightChanged: offsetHeightChanged,
          scrollHeightChanged: scrollHeightChanged
        }]), {
          nextOffsetHeight: nextOffsetHeight,
          prevOffsetHeight: offsetHeight,
          nextScrollHeight: nextScrollHeight,
          prevScrollHeight: scrollHeight
        }];
      });
      scrollToSticky();
    }

    var actualScrollTop = target.scrollTop;

    _forEachInstanceProperty(_context17 = scrollPositionObserversRef.current).call(_context17, function (observer) {
      return observer({
        scrollTop: actualScrollTop
      });
    });
  }, [animateToRef, debug, ignoreScrollEventBeforeRef, mode, offsetHeightRef, scrollHeightRef, scrollPositionObserversRef, scrollToSticky, setAtBottom, setAtEnd, setAtStart, setAtTop, setSticky, stickyRef, targetRef]);
  useEffect(function () {
    if (target) {
      var stickyButNotAtEndSince = false;
      var timeout = setImmediateInterval(function () {
        var target = targetRef.current;
        var animating = animateToRef.current !== null;

        if (stickyRef.current) {
          if (!computeViewState({
            mode: mode,
            target: target
          }).atEnd) {
            if (!stickyButNotAtEndSince) {
              stickyButNotAtEndSince = _Date$now();
            } else if (_Date$now() - stickyButNotAtEndSince > SCROLL_DECISION_DURATION) {
              // Quirks: In Firefox, after user scroll down, Firefox do two things:
              //         1. Set to a new "scrollTop"
              //         2. Fire "scroll" event
              //         For what we observed, #1 is fired about 20ms before #2. There is a chance that this stickyCheckTimeout is being scheduled between 1 and 2.
              //         That means, if we just look at #1 to decide if we should scroll, we will always scroll, in oppose to the user's intention.
              // Repro: Open Firefox, set checkInterval to a lower number, and try to scroll by dragging the scroll handler. It will jump back.
              // The "animating" check will make sure stickiness is not lost when elements are adding at a very fast pace.
              if (!animating) {
                animateFromRef.current = target.scrollTop;
                debug(function () {
                  var _context18;

                  return _concatInstanceProperty(_context18 = ["%cInterval check%c: Should sticky but not at end, calling %cscrollToSticky()%c to scroll"]).call(_context18, _toConsumableArray(styleConsole('navy')), _toConsumableArray(styleConsole('orange')));
                });
                scrollToSticky();
              }

              stickyButNotAtEndSince = false;
            }
          } else {
            stickyButNotAtEndSince = false;
          }
        } else if (target.scrollHeight <= target.offsetHeight && !stickyRef.current) {
          // When the container is emptied, we will set sticky back to true.
          debug(function () {
            var _context19;

            return [_concatInstanceProperty(_context19 = ["%cInterval check%c: Container is emptied, setting sticky back to %ctrue%c"]).call(_context19, _toConsumableArray(styleConsole('navy')), _toConsumableArray(styleConsole('purple'))), [{
              offsetHeight: target.offsetHeight,
              scrollHeight: target.scrollHeight,
              sticky: stickyRef.current
            }]];
          });
          setSticky(true);
        }
      }, Math.max(MIN_CHECK_INTERVAL, checkInterval) || MIN_CHECK_INTERVAL);
      return function () {
        return clearInterval(timeout);
      };
    }
  }, [animateToRef, checkInterval, debug, mode, scrollToSticky, setSticky, stickyRef, target, targetRef]);
  var styleToClassName = useMemo(function () {
    var emotion = emotionPool[nonce] || (emotionPool[nonce] = createEmotion({
      key: 'react-scroll-to-bottom--css-' + createCSSKey(),
      nonce: nonce
    }));
    return function (style) {
      return emotion.css(style) + '';
    };
  }, [nonce]);
  var internalContext = useMemo(function () {
    return {
      observeScrollPosition: observeScrollPosition,
      setTarget: setTarget,
      styleToClassName: styleToClassName
    };
  }, [observeScrollPosition, setTarget, styleToClassName]);
  var state1Context = useMemo(function () {
    return {
      atBottom: atBottom,
      atEnd: atEnd,
      atStart: atStart,
      atTop: atTop,
      mode: mode
    };
  }, [atBottom, atEnd, atStart, atTop, mode]);
  var state2Context = useMemo(function () {
    var animating = animateTo !== null;
    return {
      animating: animating,
      animatingToEnd: animating && isEnd(animateTo, mode),
      sticky: sticky
    };
  }, [animateTo, mode, sticky]);
  var combinedStateContext = useMemo(function () {
    return _objectSpread(_objectSpread({}, state1Context), state2Context);
  }, [state1Context, state2Context]);
  var functionContext = useMemo(function () {
    return {
      scrollTo: scrollTo,
      scrollToBottom: scrollToBottom,
      scrollToEnd: scrollToEnd,
      scrollToStart: scrollToStart,
      scrollToTop: scrollToTop
    };
  }, [scrollTo, scrollToBottom, scrollToEnd, scrollToStart, scrollToTop]);
  useEffect(function () {
    // We need to update the "scrollHeight" value to latest when the user do a focus inside the box.
    //
    // This is because:
    // - In our code that mitigate Chrome synthetic scrolling, that code will look at whether "scrollHeight" value is latest or not.
    // - That code only run on "scroll" event.
    // - That means, on every "scroll" event, if the "scrollHeight" value is not latest, we will skip modifying the stickiness.
    // - That means, if the user "focus" to an element that cause the scroll view to scroll to the bottom, the user agent will fire "scroll" event.
    //   Since the "scrollHeight" is not latest value, this "scroll" event will be ignored and stickiness will not be modified.
    // - That means, if the user "focus" to a newly added element that is at the end of the scroll view, the "scroll to bottom" button will continue to show.
    //
    // Repro in Chrome:
    // 1. Fill up a scroll view
    // 2. Scroll up, the "scroll to bottom" button should show up
    // 3. Click "Add a button"
    // 4. Click on the scroll view (to pseudo-focus on it)
    // 5. Press TAB, the scroll view will be at the bottom
    //
    // Expect:
    // - The "scroll to bottom" button should be gone.
    if (target) {
      var handleFocus = function handleFocus() {
        scrollHeightRef.current = target.scrollHeight;
      };

      target.addEventListener('focus', handleFocus, {
        capture: true,
        passive: true
      });
      return function () {
        return target.removeEventListener('focus', handleFocus);
      };
    }
  }, [target]);
  debug(function () {
    var _context20;

    return [_concatInstanceProperty(_context20 = ["%cRender%c: Render"]).call(_context20, _toConsumableArray(styleConsole('cyan', ''))), {
      animateTo: animateTo,
      animating: animateTo !== null,
      sticky: sticky,
      target: target
    }];
  });
  return /*#__PURE__*/React.createElement(InternalContext.Provider, {
    value: internalContext
  }, /*#__PURE__*/React.createElement(FunctionContext.Provider, {
    value: functionContext
  }, /*#__PURE__*/React.createElement(StateContext.Provider, {
    value: combinedStateContext
  }, /*#__PURE__*/React.createElement(State1Context.Provider, {
    value: state1Context
  }, /*#__PURE__*/React.createElement(State2Context.Provider, {
    value: state2Context
  }, children, target && /*#__PURE__*/React.createElement(EventSpy, {
    debounce: debounce,
    name: "scroll",
    onEvent: handleScroll,
    target: target
  }), target && animateTo !== null && /*#__PURE__*/React.createElement(SpineTo, {
    name: "scrollTop",
    onEnd: handleSpineToEnd,
    target: target,
    value: animateTo
  }))))));
};

Composer.defaultProps = {
  checkInterval: 100,
  children: undefined,
  debounce: 17,
  debug: undefined,
  initialScrollBehavior: 'smooth',
  mode: undefined,
  nonce: undefined,
  scroller: DEFAULT_SCROLLER
};
Composer.propTypes = {
  checkInterval: PropTypes.number,
  children: PropTypes.any,
  debounce: PropTypes.number,
  debug: PropTypes.bool,
  initialScrollBehavior: PropTypes.oneOf(['auto', 'smooth']),
  mode: PropTypes.oneOf(['bottom', 'top']),
  nonce: PropTypes.string,
  scroller: PropTypes.func
};
export default Composer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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