import "core-js/modules/es.function.name.js";
import _Math$sign from "@babel/runtime-corejs3/core-js-stable/math/sign";
import _Date$now from "@babel/runtime-corejs3/core-js-stable/date/now";

/* eslint no-magic-numbers: ["error", { "ignore": [0, 1, 1.5, 5] }] */
import PropTypes from 'prop-types';
import { useCallback, useLayoutEffect, useRef } from 'react';

function squareStepper(current, to) {
  var sign = _Math$sign(to - current);

  var step = Math.sqrt(Math.abs(to - current));
  var next = current + step * sign;

  if (sign > 0) {
    return Math.min(to, next);
  }

  return Math.max(to, next);
}

function step(from, to, stepper, index) {
  var next = from;

  for (var i = 0; i < index; i++) {
    next = stepper(next, to);
  }

  return next;
}

var SpineTo = function SpineTo(_ref) {
  var name = _ref.name,
      onEnd = _ref.onEnd,
      target = _ref.target,
      value = _ref.value;
  var animator = useRef();
  var animate = useCallback(function (name, from, to, index) {
    var start = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : _Date$now();

    if (to === '100%' || typeof to === 'number') {
      cancelAnimationFrame(animator.current);
      animator.current = requestAnimationFrame(function () {
        if (target) {
          var toNumber = to === '100%' ? target.scrollHeight - target.offsetHeight : to;
          var nextValue = step(from, toNumber, squareStepper, (_Date$now() - start) / 5);

          if (Math.abs(toNumber - nextValue) < 1.5) {
            nextValue = toNumber;
          }

          target[name] = nextValue;

          if (toNumber === nextValue) {
            onEnd && onEnd(true);
          } else {
            animate(name, from, to, index + 1, start);
          }
        }
      });
    }
  }, [animator, onEnd, target]);
  var handleCancelAnimation = useCallback(function () {
    cancelAnimationFrame(animator.current);
    onEnd && onEnd(false);
  }, [onEnd]);
  useLayoutEffect(function () {
    animate(name, target[name], value, 1);

    if (target) {
      target.addEventListener('pointerdown', handleCancelAnimation, {
        passive: true
      });
      target.addEventListener('wheel', handleCancelAnimation, {
        passive: true
      });
      return function () {
        target.removeEventListener('pointerdown', handleCancelAnimation);
        target.removeEventListener('wheel', handleCancelAnimation);
        cancelAnimationFrame(animator.current);
      };
    }

    return function () {
      return cancelAnimationFrame(animator.current);
    };
  }, [animate, animator, handleCancelAnimation, name, target, value]);
  return false;
};

SpineTo.propTypes = {
  name: PropTypes.string.isRequired,
  onEnd: PropTypes.func,
  target: PropTypes.any.isRequired,
  value: PropTypes.oneOfType([PropTypes.number, PropTypes.oneOf(['100%'])]).isRequired
};
export default SpineTo;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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