/* global global:readonly, process:readonly */

/* eslint no-empty: ["error", { "allowEmptyCatch": true }] */
function setMetaTag(name, content) {
  try {
    var _global = global,
        document = _global.document;

    if (typeof document !== 'undefined' && document.createElement && document.head && document.head.appendChild) {
      var meta = document.querySelector("html meta[name=\"".concat(encodeURI(name), "\"]")) || document.createElement('meta');
      meta.setAttribute('name', name);
      meta.setAttribute('content', content);
      document.head.appendChild(meta);
    }
  } catch (err) {}
}

export default function addVersionToMetaTag() {
  setMetaTag('react-scroll-to-bottom:version', "4.2.0");
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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