import { Link, useLocation } from "react-router-dom";
import "./style.css";
import { images } from "../../../Assets";

export const AuthLayout = (props) => {
  const location = useLocation();
  const pathname = location?.pathname;
  const [, firstSegment] = pathname.split("/");

  return (
    <>
      <section className={`authBg ${props?.authClasMain}`}>
        <div className="container">
          <div className="row g-0 justify-content-center align-items-center">
            <div className="col-12">
              <div className="authBox mx-auto">
                <div className="auth-form-inner">
                  <div className="text-center">
                    <h2 className="text-uppercase semi-bold">{props?.authTitle}</h2>
                    {props?.authPara && (
                      <p className="authPara text-capitalize grayColor">{props?.authPara}</p>
                    )}
                  </div>
                  {props?.children}
                  {props?.backOption && (
                    <div className="text-center mt-4">
                      <Link
                        to={`/${firstSegment}`}
                        className="fw-normal text-decoration-underline primaryColor"
                      >
                        Back to Login
                      </Link>
                    </div>
                  )}
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};
