import { useEffect, useState } from "react";
import { Link, useNavigate } from "react-router-dom";
import { Navbar, Container, Nav, Dropdown } from "react-bootstrap";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faUser,
  faEllipsisV,
  faSignOut,
  faBars,
} from "@fortawesome/free-solid-svg-icons";
import "./style.css";
import { images } from "../../../Assets";
import CustomModal from "../../CustomModal";
import { useLogout } from "../../../Services/Auth";
import HeaderNotification from "../../HeaderNotification";
import Toast, { showToast } from "../../Toast";
import { useAuth } from "../../../Hooks/useAuth";
import { notificationsData } from "../../../Config/data";
import { getAll } from "../../../Services/Api";

export const Header = (props) => {
  const navigate = useNavigate();
  const { role, user } = useAuth();
  const handleLogout = useLogout();
  const [showModal, setShowModal] = useState(false);
  const [notificationData, setNotificationData] = useState([]);

  const getNotification = async () => {
    let url = `/${role}/notification/all/list`;
    const response = await getAll(url);
    // const response = notificationsData;
    if (response.status) {
      setNotificationData(response?.data);
    }
  };
  useEffect(() => {
    getNotification()
  }, []);

  const logout = async () => {
    showToast("Logout Successfully", "success");
    await handleLogout(role);
    setTimeout(() => {
      navigate(`/${role}`);
    }, 1000);
  };

  return (
    <header>
      <Navbar className="customHeader" expand="md">
        <Container fluid>
          <Link to={"/admin/dashboard"} className="siteLogo order-2 order-lg-1">
            <img src={images.logo} alt="" />
          </Link>
          <Navbar.Toggle className="order-4 order-lg-2 notButton whiteColor">
            <FontAwesomeIcon className="bell-icon whiteColor" icon={faEllipsisV} />
          </Navbar.Toggle>
          <Navbar.Collapse
            id="basic-navbar-nav"
            className="customCollapse order-3"
          >
            <Nav className="ms-auto">
              <HeaderNotification
                notificationData={notificationData}
                getNotification={getNotification}
              />
              <Dropdown className="userDropdown">
                <Dropdown.Toggle
                  variant="transparent"
                  className="notButton whiteColor toggleButton"
                >
                  <div className="userImage d-flex align-items-center">
                    <img
                      src={user?.image_url}
                      alt=""
                      className="img-fluid"
                    />
                    <h6 className="ms-2 mb-0">{user?.full_name}</h6>
                  </div>
                </Dropdown.Toggle>
                <Dropdown.Menu className="userMenu" align="end">
                  <Link className="userMenuItem" to={`/${role}/profile`}>
                    <FontAwesomeIcon
                      className="me-2 yellow-text"
                      icon={faUser}
                    />{" "}
                    Profile
                  </Link>
                  <Link
                    onClick={() => setShowModal(true)}
                    className="userMenuItem"
                  >
                    <FontAwesomeIcon
                      className="me-1 yellow-text"
                      icon={faSignOut}
                    />{" "}
                    Logout
                  </Link>
                </Dropdown.Menu>
              </Dropdown>
            </Nav>
          </Navbar.Collapse>
          <button className="notButton ms-md-2 order-lg-4 order-md-4 order-1">
            <FontAwesomeIcon
              className="bell-icon whiteColor"
              onClick={props.sidebarToggle}
              icon={faBars}
            />
          </button>
        </Container>
      </Navbar>
      <Toast />
      <CustomModal
        show={showModal}
        close={() => {
          setShowModal(false);
        }}
        action={() => {
          logout();
          setShowModal(false);
        }}
        heading="Are you sure you want to logout?"
      />
    </header>
  );
};
